/*
 * Decompiled with CFR 0.152.
 */
package editor.view.actions;

import editor.ext.jgraph.MyComplexNode;
import editor.ext.jgraph.MyPort;
import editor.view.ModelWindow;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.jgraph.graph.BasicMarqueeHandler;
import org.jgraph.graph.CellView;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.PortView;

public class MyMarqueeHandler
extends BasicMarqueeHandler {
    protected Point2D start;
    protected Point2D current;
    protected PortView port;
    protected PortView firstPort;
    protected ModelWindow parentCanvas;
    protected MyComplexNode graph;

    public MyMarqueeHandler(ModelWindow parentCanvas) {
        this.parentCanvas = parentCanvas;
        this.graph = parentCanvas.getGraph();
    }

    public boolean isForceMarqueeEvent(MouseEvent e) {
        if (e.isShiftDown()) {
            return false;
        }
        if (SwingUtilities.isRightMouseButton(e)) {
            return true;
        }
        this.port = this.getSourcePortAt(e.getPoint());
        if (this.port != null && this.graph.isPortsVisible()) {
            return true;
        }
        return super.isForceMarqueeEvent(e);
    }

    public void mousePressed(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e)) {
            Object cell = this.graph.getFirstCellForLocation(e.getX(), e.getY());
            JPopupMenu menu = this.parentCanvas.createPopupMenu(e.getPoint(), cell);
            menu.show((Component)((Object)this.graph), e.getX(), e.getY());
        } else if (this.port != null && this.graph.isPortsVisible()) {
            this.start = this.graph.toScreen(this.port.getLocation());
            this.firstPort = this.port;
        } else {
            super.mousePressed(e);
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (this.start != null) {
            Graphics g = this.graph.getGraphics();
            PortView newPort = this.getTargetPortAt(e.getPoint());
            if (newPort == null || newPort != this.port) {
                this.paintConnector(Color.black, this.graph.getBackground(), g);
                this.port = newPort;
                this.current = this.port != null ? this.graph.toScreen(this.port.getLocation()) : this.graph.snap(e.getPoint());
                this.paintConnector(this.graph.getBackground(), Color.black, g);
            }
        }
        super.mouseDragged(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PortView getSourcePortAt(Point2D point) {
        PortView result;
        this.graph.setJumpToDefaultPort(false);
        try {
            result = this.graph.getPortViewAt(point.getX(), point.getY());
        }
        finally {
            this.graph.setJumpToDefaultPort(true);
        }
        return result;
    }

    protected PortView getTargetPortAt(Point2D point) {
        return this.graph.getPortViewAt(point.getX(), point.getY());
    }

    public void mouseReleased(MouseEvent e) {
        if (e != null && this.port != null && this.firstPort != null && this.firstPort != this.port) {
            this.parentCanvas.connect((MyPort)((Object)this.firstPort.getCell()), (MyPort)((Object)this.port.getCell()));
            e.consume();
        } else {
            this.graph.repaint();
        }
        this.port = null;
        this.firstPort = null;
        this.current = null;
        this.start = null;
        super.mouseReleased(e);
    }

    public void mouseMoved(MouseEvent e) {
        if (e != null && this.getSourcePortAt(e.getPoint()) != null && this.graph.isPortsVisible()) {
            this.graph.setCursor(new Cursor(12));
            e.consume();
        } else {
            super.mouseMoved(e);
        }
    }

    protected void paintConnector(Color fg, Color bg, Graphics g) {
        g.setColor(fg);
        g.setXORMode(bg);
        this.paintPort(this.graph.getGraphics());
        if (this.firstPort != null && this.start != null && this.current != null) {
            g.drawLine((int)this.start.getX(), (int)this.start.getY(), (int)this.current.getX(), (int)this.current.getY());
        }
    }

    protected void paintPort(Graphics g) {
        if (this.port != null) {
            boolean o = GraphConstants.getOffset((Map)this.port.getAllAttributes()) != null;
            Rectangle2D r = o ? this.port.getBounds() : this.port.getParentView().getBounds();
            r = this.graph.toScreen((Rectangle2D)r.clone());
            r.setFrame(r.getX() - 3.0, r.getY() - 3.0, r.getWidth() + 6.0, r.getHeight() + 6.0);
            this.graph.getUI().paintCell(g, (CellView)this.port, r, true);
        }
    }
}

