/*
 * Decompiled with CFR 0.152.
 */
package editor.view.pane;

import editor.ext.model.TreeXml;
import editor.ext.model.TreeXmlNodeInfo;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class LibraryPane
extends JScrollPane {
    private static final long serialVersionUID = 1L;
    private JTree tree;

    public LibraryPane(JTree tree) {
        super(tree);
        super.setFont(new Font("Dialog", 0, 12));
        super.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Library"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        super.setBackground(Color.WHITE);
        super.setPreferredSize(new Dimension(300, 300));
        this.tree = tree;
        this.tree.setRootVisible(false);
        this.tree.getSelectionModel().setSelectionMode(1);
    }

    public void addLibrary(File file) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document docXmlLib = builder.parse(file.toURI().toString());
        Element xmlLibrary = (Element)docXmlLib.getElementsByTagName("library").item(0);
        TreeXml treeModel = (TreeXml)this.tree.getModel();
        DefaultMutableTreeNode currentRoot = (DefaultMutableTreeNode)treeModel.getRoot();
        DefaultMutableTreeNode currentLibrary = treeModel.addChild(currentRoot, new TreeXmlNodeInfo(xmlLibrary.getAttribute("id")));
        NodeList xmlAtomicList = xmlLibrary.getElementsByTagName("atomic");
        for (int i = 0; i < xmlAtomicList.getLength(); ++i) {
            Element xmlAtomic = (Element)xmlAtomicList.item(i);
            String className = xmlAtomic.getAttribute("class");
            String[] parts = className.split("\\.");
            currentRoot = currentLibrary;
            for (int j = 0; j < parts.length; ++j) {
                String part = parts[j];
                currentRoot = j == parts.length - 1 ? treeModel.addChild(currentRoot, new TreeXmlNodeInfo(xmlAtomic)) : treeModel.addChild(currentRoot, new TreeXmlNodeInfo(part));
            }
        }
        treeModel.reload();
    }
}

