/*
 * Decompiled with CFR 0.152.
 */
package lib.atomic.continuous;

import java.util.Iterator;
import xdevs.kernel.modeling.AtomicImpl;
import xdevs.kernel.modeling.MessageImpl;
import xdevs.kernel.modeling.api.Message;

public class IntegratorEulerN
extends AtomicImpl {
    public static final String in = "in";
    public static final String out = "out";
    private double[] dx;
    private double[] x;

    public IntegratorEulerN(String name, double sampleTime, double[] x0) {
        super(name);
        super.setSigma(sampleTime);
        super.addInport(in);
        super.addOutport(out);
        this.dx = new double[x0.length];
        this.x = new double[x0.length];
        for (int i = 0; i < x0.length; ++i) {
            this.x[i] = x0[i];
            this.dx[i] = 0.0;
        }
    }

    public void deltint() {
        this.EulerIntegrationStep(super.getSigma());
    }

    public void deltext(double e, Message x) {
        Iterator<Object> itr = x.getValuesOnPort(in).iterator();
        this.dx = (double[])itr.next();
        this.EulerIntegrationStep(e);
    }

    public Message lambda() {
        MessageImpl msg = new MessageImpl();
        msg.add(out, this.x);
        return msg;
    }

    public void EulerIntegrationStep(double delta) {
        for (int i = 0; i < this.x.length; ++i) {
            int n = i;
            this.x[n] = this.x[n] + this.dx[i] * delta;
        }
    }
}

