/*
 * Decompiled with CFR 0.152.
 */
package lib.atomic.continuous.qss;

import java.util.Iterator;
import xdevs.kernel.modeling.AtomicImpl;
import xdevs.kernel.modeling.MessageImpl;
import xdevs.kernel.modeling.api.Message;

public class IntegratorQSS
extends AtomicImpl {
    public static final String in = "in";
    public static final String out = "out";
    private double dx;
    private double x;
    private double q;
    private double dq;
    private double eps;

    public IntegratorQSS(String name, double dq, double eps, double x0) {
        super(name);
        super.addInport(in);
        super.addOutport(out);
        super.setSigma(0.0);
        this.dq = dq;
        this.eps = eps;
        this.x = x0;
        this.dx = 0.0;
        this.q = Math.floor(this.x / dq) * dq;
    }

    public void deltint() {
        this.x += this.dx * super.getSigma();
        if (this.dx == 0.0) {
            super.setSigma(Double.POSITIVE_INFINITY);
        } else {
            super.setSigma(this.dq / this.dx * Math.signum(this.dx));
            this.q += this.dq * Math.signum(this.dx);
        }
    }

    public void deltext(double e, Message input) {
        this.x += this.dx * e;
        Iterator<Object> itrdx = input.getValuesOnPort(in).iterator();
        this.dx = (Double)itrdx.next();
        if (this.dx == 0.0) {
            super.setSigma(Double.POSITIVE_INFINITY);
        } else if (this.dx > 0.0) {
            super.setSigma((this.q + this.dq - this.x) / this.dx);
        } else {
            super.setSigma((this.q - this.eps - this.x) / this.dx);
        }
    }

    public Message lambda() {
        MessageImpl msg = new MessageImpl();
        double y = this.q + this.dq * Math.signum(this.dx);
        msg.add(out, y);
        return msg;
    }
}

