/*
 * Decompiled with CFR 0.152.
 */
package lib.atomic.dynamic.continuous;

import lib.atomic.dynamic.IDynSys;
import xdevs.kernel.modeling.AtomicImpl;
import xdevs.kernel.modeling.MessageImpl;
import xdevs.kernel.modeling.api.Message;

public class MM_SScsys
extends AtomicImpl {
    public static final String out = "out";
    public static final String outx = "outx";
    public static final String in = "in";
    private IDynSys mymodel;
    private Double[] x;
    private Double[] u;
    private Double[] uold;
    private Double[] y;
    private double dt;
    private String utype;
    private final int YES = 1;
    private final int NO = 0;
    private int debug = 1;
    private double tiempo = 0.0;

    public MM_SScsys(String name, IDynSys model) {
        super(name);
        this.addInport(in);
        this.addOutport(out);
        this.addOutport(outx);
        this.mymodel = model;
        this.x = new Double[this.mymodel.getNx()];
        this.x = this.mymodel.getState();
        if (this.mymodel.getNu() == 0) {
            super.setSigma(0.0);
            this.u = new Double[1];
            this.uold = new Double[1];
            this.u[0] = 0.0;
            this.uold[0] = 0.0;
        } else {
            super.setSigma(Double.POSITIVE_INFINITY);
            this.u = new Double[this.mymodel.getNu()];
            this.uold = new Double[this.mymodel.getNu()];
        }
        super.setPhase("initial");
    }

    public double ta(double t) {
        return super.getSigma();
    }

    public void deltext(double e, Message msg) {
        Object uu = msg.getValuesOnPort(in).iterator().next();
        if (super.getPhase() == "initial") {
            this.utype = this.getTypeUu(uu);
            this.getSignalU(this.utype, uu);
            this.uold = (Double[])this.u.clone();
        } else {
            this.uold = (Double[])this.u.clone();
            this.getSignalU(this.utype, uu);
            super.setPhase("new");
        }
        super.setSigma(0.0);
        this.dt = e;
        if (this.debug == 1) {
            System.out.println("MOORE_SScsys deltext t: " + (this.tiempo + e) + ", " + super.getPhase());
            for (int i = 0; i < this.u.length; ++i) {
                System.out.println("u(" + i + "): " + this.u[i]);
                System.out.println("u0(" + i + "): " + this.uold[i]);
            }
        }
    }

    public void deltint() {
        super.setSigma(this.mymodel.getSampling());
        super.setPhase("old");
        this.tiempo += this.dt;
        this.dt = this.mymodel.getSampling();
        this.tiempo += this.dt;
        if (this.debug == 1) {
            System.out.println("MOORE_SScsys deltin  tnext: " + this.tiempo);
            for (int i = 0; i < this.x.length; ++i) {
                System.out.println(" x(" + (i + 1) + "): " + this.x[i]);
            }
        }
    }

    public Message lambda() {
        if (super.getPhase() == "initial") {
            this.y = this.mymodel.gxut(this.dt, this.x, this.uold);
            super.setPhase("new");
        } else {
            double h = super.getPhase() == "new" ? this.dt : this.mymodel.getSampling();
            this.x = this.mymodel.update(h, this.x, this.uold);
            this.y = this.mymodel.gxut(this.dt, this.x, this.uold);
            this.uold = (Double[])this.u.clone();
        }
        MessageImpl msg = new MessageImpl();
        msg.add(out, this.y);
        msg.add(outx, this.x);
        if (this.debug == 1) {
            System.out.println("MOORE_SScsys lambda t: " + this.tiempo + ", " + super.getPhase() + " s: " + this.ta());
            for (int i = 0; i < this.y.length; ++i) {
                System.out.println("y(" + i + "): " + this.y[i]);
            }
        }
        return msg;
    }

    public void deltcon(double e, Message x) {
        this.deltext(e, x);
        this.deltint();
    }

    private String getTypeUu(Object uu) {
        String uutype = uu.getClass().getCanonicalName();
        if (uutype.equals("java.lang.Double[]")) {
            uutype = "array";
        } else if (uutype.equals("java.lang.Double")) {
            uutype = "Double";
        } else {
            uutype = " ";
            System.out.println(super.getName() + ": MOORE_SScsys, \u00a1error tipo de dato de entrada!");
            for (int i = 0; i < this.mymodel.getNu(); ++i) {
                this.u[i] = 0.0;
            }
        }
        return uutype;
    }

    private void getSignalU(String utype, Object uu) {
        if (utype == "array") {
            System.arraycopy(uu, 0, this.u, 0, this.u.length);
        } else if (utype == "Double") {
            this.u[0] = (Double)uu;
        }
    }
}

