/*
 * Decompiled with CFR 0.152.
 */
package lib.atomic.general;

import java.util.Collection;
import xdevs.kernel.modeling.AtomicImpl;
import xdevs.kernel.modeling.MessageImpl;
import xdevs.kernel.modeling.api.Message;

public class FlowGenerator
extends AtomicImpl {
    public static final String stop = "stop";
    public static final String out = "out";
    protected double period;
    protected double flow;
    protected double _amplitude;
    protected double _bias;
    protected double _phase;
    protected double _frecuency;
    protected boolean tend = true;
    protected double time;

    public FlowGenerator(String name, double period, double time, double _amplitude, double _phase, double _frecuency, double _bias) {
        super(name);
        this.addInport(stop);
        this.addOutport(out);
        this.period = period;
        this.setSigma(period);
        this.time = time;
        this._amplitude = _amplitude;
        this._phase = _phase;
        this._frecuency = _frecuency;
        this._bias = _bias;
    }

    public void deltint() {
        this.time += this.period;
        this.flow = new Double(this._amplitude * Math.sin(this._frecuency * this.time + this._phase) + this._bias);
        this.setSigma(this.period);
    }

    public void deltext(double e, Message x) {
        Collection<Object> values = x.getValuesOnPort(stop);
        if (!values.isEmpty()) {
            this.setSigma(Double.POSITIVE_INFINITY);
        }
    }

    public Message lambda() {
        MessageImpl msg = new MessageImpl();
        msg.add(out, this.flow);
        return msg;
    }
}

