/*
 * Decompiled with CFR 0.152.
 */
package lib.atomic.math;

import java.util.Iterator;
import xdevs.kernel.modeling.AtomicImpl;
import xdevs.kernel.modeling.MessageImpl;
import xdevs.kernel.modeling.api.Message;

public class ClockSISampler
extends AtomicImpl {
    public static final String signal = "signal";
    public static final String clock = "clock";
    public static final String out = "out";
    protected Double output;
    private int debug = 1;
    private double tiempo = 0.0;

    public ClockSISampler(String name) {
        super(name);
        this.addInport(signal);
        this.addInport(clock);
        this.addOutport(out);
        super.setSigma(Double.POSITIVE_INFINITY);
        super.setPhase("passive");
    }

    public void deltext(double e, Message x) {
        Iterator<Object> itr2;
        Iterator<Object> itr1 = x.getValuesOnPort(signal).iterator();
        if (itr1.hasNext()) {
            this.output = (double)((Double)itr1.next());
        }
        if ((itr2 = x.getValuesOnPort(clock).iterator()).hasNext()) {
            super.setSigma(0.0);
            super.setPhase("transitory");
        }
        if (this.debug == 1) {
            this.tiempo += e;
            System.out.println("CSIS deltext  t: " + this.tiempo + " output: " + this.output + " " + super.getPhase());
        }
    }

    public void deltint() {
        super.setSigma(Double.POSITIVE_INFINITY);
        super.setPhase("passive");
        if (this.debug == 1) {
            System.out.println("CSIS deltin  t: " + this.tiempo + " output: " + this.output + " " + super.getPhase());
        }
    }

    public Message lambda() {
        MessageImpl msg = new MessageImpl();
        msg.add(out, this.output);
        if (this.debug == 1) {
            System.out.println("CSIS lambda t: " + this.tiempo + " y: " + this.output + " " + super.getPhase() + " s: " + this.ta());
        }
        return msg;
    }
}

