/*
 * Decompiled with CFR 0.152.
 */
package lib.atomic.math;

import java.util.Iterator;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import xdevs.kernel.modeling.AtomicImpl;
import xdevs.kernel.modeling.MessageImpl;
import xdevs.kernel.modeling.api.Message;

public class Comparator
extends AtomicImpl {
    public static final String in0 = "in0";
    public static final String in1 = "in1";
    public static final String out = "out";
    protected Double u0;
    protected Double u1;
    protected Double vL;
    protected Double vH;
    protected Double y;

    public Comparator(String name, Double vL, Double vH) {
        super(name);
        this.addInport(in0);
        this.addInport(in1);
        this.addOutport(out);
        this.vL = vL;
        this.vH = vH;
        this.u0 = null;
        this.u1 = null;
        this.y = null;
    }

    public Comparator(Element xmlNode) {
        super(xmlNode);
        this.addInport(in0);
        this.addInport(in1);
        this.addOutport(out);
        this.u0 = null;
        this.u1 = null;
        this.y = null;
        NodeList xmlProperties = xmlNode.getElementsByTagName("property");
        for (int i = 0; i < xmlProperties.getLength(); ++i) {
            Element xmlProperty = (Element)xmlProperties.item(i);
            String propertyName = xmlProperty.getAttribute("name");
            if (propertyName.equals("vL")) {
                this.vL = Double.valueOf(xmlProperty.getAttribute("value"));
                continue;
            }
            if (!propertyName.equals("vH")) continue;
            this.vH = Double.valueOf(xmlProperty.getAttribute("value"));
        }
    }

    public double ta(double t) {
        return super.getSigma();
    }

    public void deltint() {
        super.setSigma(Double.POSITIVE_INFINITY);
    }

    public void deltext(double e, Message x) {
        Iterator<Object> itr = x.getValuesOnPort(in0).iterator();
        if (itr.hasNext()) {
            this.u0 = (Double)itr.next();
        }
        if ((itr = x.getValuesOnPort(in1).iterator()).hasNext()) {
            this.u1 = (Double)itr.next();
        }
        if (this.u0 == null || this.u1 == null) {
            return;
        }
        this.y = this.u0 > this.u1 ? this.vH : this.vL;
        super.setSigma(0.0);
    }

    public Message lambda() {
        MessageImpl msg = new MessageImpl();
        msg.add(out, this.y);
        return msg;
    }
}

