/*
 * Decompiled with CFR 0.152.
 */
package lib.atomic.math;

import java.util.Iterator;
import xdevs.kernel.modeling.AtomicImpl;
import xdevs.kernel.modeling.MessageImpl;
import xdevs.kernel.modeling.api.Message;

public class WeightedSum
extends AtomicImpl {
    public static final String out = "out";
    private double[] w;
    private double[] u;

    public WeightedSum(String name, double[] weights) {
        super(name);
        int i;
        for (i = 0; i < weights.length; ++i) {
            super.addInport("in" + i);
        }
        super.addOutport(out);
        this.w = weights;
        this.u = new double[this.w.length];
        for (i = 0; i < this.w.length; ++i) {
            this.u[i] = 0.0;
        }
    }

    public void deltint() {
        super.setSigma(Double.POSITIVE_INFINITY);
    }

    public void deltext(double e, Message x) {
        for (int i = 0; i < this.w.length; ++i) {
            Iterator<Object> itr = x.getValuesOnPort("in" + i).iterator();
            if (!itr.hasNext()) continue;
            Object next = itr.next();
            this.u[i] = (Double)next;
        }
        super.setSigma(0.0);
    }

    public Message lambda() {
        MessageImpl msg = new MessageImpl();
        double y = 0.0;
        for (int i = 0; i < this.u.length; ++i) {
            y += this.w[i] * this.u[i];
        }
        msg.add(out, y);
        return msg;
    }
}

