/*
 * Decompiled with CFR 0.152.
 */
package lib.atomic.sinks;

import extra.views.TimeSeriesView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import xdevs.kernel.modeling.AtomicImpl;
import xdevs.kernel.modeling.api.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeSeriesScope
extends AtomicImpl {
    private TimeSeriesView chart;
    private double time;
    private Collection<String> seriesName;

    public TimeSeriesScope(String name, double t0, String topTitle, String title, String xTitle, String yTitle, Collection<String> seriesName) {
        super(name);
        for (String serieName : seriesName) {
            super.addInport(serieName);
        }
        this.time = t0;
        this.chart = new TimeSeriesView(topTitle, title, xTitle, yTitle, seriesName);
        this.seriesName = seriesName;
    }

    public TimeSeriesScope(String name, double t0, String topTitle, String title, String xTitle, String yTitle, String serieName) {
        super(name);
        ArrayList<String> seriesName = new ArrayList<String>();
        seriesName.add(serieName);
        for (String portName : seriesName) {
            super.addInport(portName);
        }
        this.time = t0;
        this.chart = new TimeSeriesView(topTitle, title, xTitle, yTitle, seriesName);
        this.seriesName = seriesName;
    }

    @Override
    public void deltint() {
        this.time += super.getSigma();
        super.setSigma(Double.POSITIVE_INFINITY);
    }

    @Override
    public void deltext(double e, Message x) {
        this.time += e;
        for (String serieName : this.seriesName) {
            Iterator<Object> itr = x.getValuesOnPort(serieName).iterator();
            if (!itr.hasNext()) continue;
            double y = (Double)itr.next();
            this.chart.add(this.time, y, serieName);
        }
    }

    @Override
    public Message lambda() {
        return null;
    }
}

