/*
 * Decompiled with CFR 0.152.
 */
package lib.atomic.sources;

import xdevs.kernel.modeling.AtomicImpl;
import xdevs.kernel.modeling.MessageImpl;
import xdevs.kernel.modeling.api.Message;

public class PiecewiseStepFunctionGenerator
extends AtomicImpl {
    public static final String in = "in";
    public static final String out = "out";
    protected double[][] Steps = new double[][]{{0.0, -1.0}, {1.0, 1.0}};
    private double output;
    private double actualTime;
    private double previousTime;
    private int index = 0;
    private int debug = 1;
    private double tiempo = 0.0;

    public PiecewiseStepFunctionGenerator(String name, double[][] Steps) {
        super(name);
        this.addInport(in);
        this.addOutport(out);
        super.setSigma(0.0);
        super.setPhase("initial");
        this.Steps = Steps;
        this.output = Steps[this.index][0];
        this.actualTime = 0.0;
        ++this.index;
    }

    public double ta(double t) {
        return super.getSigma();
    }

    public void deltext(double e, Message x) {
    }

    public void deltint() {
        if (this.index < this.Steps.length) {
            this.previousTime = this.actualTime;
            this.actualTime = this.Steps[this.index][1];
            this.output = this.Steps[this.index][0];
            super.setSigma(this.actualTime - this.previousTime);
            super.setPhase("active");
            ++this.index;
        } else {
            super.setSigma(Double.POSITIVE_INFINITY);
            super.setPhase("passive");
        }
    }

    public Message lambda() {
        MessageImpl msg = new MessageImpl();
        msg.add(out, this.output);
        if (this.debug == 1) {
            this.tiempo += super.getSigma();
            System.out.println("t: " + this.tiempo + "; y : " + this.output);
        }
        return msg;
    }
}

