/*
 * Decompiled with CFR 0.152.
 */
package lib.atomic.sources;

import xdevs.kernel.modeling.AtomicImpl;
import xdevs.kernel.modeling.MessageImpl;
import xdevs.kernel.modeling.api.Message;

public class QRamp
extends AtomicImpl {
    public static final String in = "in";
    public static final String out = "out";
    protected Double _slope;
    protected Double _startTime;
    protected Double _qout;
    protected Double _outPut;
    protected double _dt = 0.0;
    private int debug = 0;
    private double tiempo = 0.0;

    public QRamp(String name, Double sL, Double sT, Double iO) {
        super(name);
        this.addInport(in);
        this.addOutport(out);
        this._slope = sL;
        this._startTime = sT;
        this._outPut = iO;
        this._qout = 0.001;
        super.setSigma(0.0);
        super.setPhase("initial");
    }

    public QRamp(String name, Double sL, Double sT, Double iO, Double q) {
        this(name, sL, sT, iO);
        this._qout = q;
    }

    public double ta(double t) {
        return super.getSigma();
    }

    public void deltint() {
        if (super.getPhase() == "initial") {
            super.setSigma(this._startTime);
            super.setPhase("active");
            return;
        }
        this._dt = Math.abs(this._slope) <= Double.MIN_VALUE ? Double.MAX_VALUE : this._qout / Math.abs(this._slope);
        super.setSigma(this._dt);
        this._outPut = this._outPut + this._dt * this._slope;
    }

    public void deltext(double e, Message x) {
    }

    public Message lambda() {
        MessageImpl msg = new MessageImpl();
        if (this._outPut != null) {
            msg.add(out, this._outPut);
        }
        if (this.debug == 1) {
            this.tiempo += super.getSigma();
            System.out.println("t: " + this.tiempo + "; y : " + this._outPut);
        }
        return msg;
    }
}

