/*
 * Decompiled with CFR 0.152.
 */
package proyectoSI.barcos;

import java.util.Iterator;
import java.util.Vector;
import proyectoSI.matematico.IFuncion;
import proyectoSI.matematico.IIntegrador;
import proyectoSI.matematico.RungeKutta;
import xdevs.kernel.modeling.AtomicStateImpl;
import xdevs.kernel.modeling.MessageImpl;
import xdevs.kernel.modeling.api.Message;

public class ControladorRumboBarco
extends AtomicStateImpl
implements IFuncion {
    private IIntegrador integrador;
    public static final String puertoInMRef = "puertoInMRef";
    public static final String puertoInBarco = "puertoInBarco";
    public static final String puertoOut = "puertoOut";
    public static final String dt = "dt";
    public static final String tactual = "tactual";
    public static final String psir = "psir";
    public static final String rr = "rr";
    public static final String alfar = "alfar";
    public static final String psi = "psi";
    public static final String r = "r";
    public static final String deltac = "deltac";
    public static final String x1 = "x1";
    public static final String Kp = "Kp";
    public static final String Kn = "Kn";
    public static final String Tn = "Tn";
    public static final String Td = "Td";
    public static final String Ti = "Ti";

    public ControladorRumboBarco(String name, double _kp, double _kn, double _tn, double _td, double _ti) {
        super(name);
        this.addState(x1);
        this.addState(deltac);
        this.addInport(puertoInMRef);
        this.addInport(puertoInBarco);
        this.addOutport(puertoOut);
        this.integrador = new RungeKutta();
        this.addState(Kp);
        this.addState(Kn);
        this.addState(Tn);
        this.addState(Td);
        this.addState(Ti);
        this.addState(tactual);
        this.addState(psir);
        this.addState(rr);
        this.addState(alfar);
        this.addState(psi);
        this.addState(r);
        this.addState(x1);
        this.setStateValue(Kp, _kp);
        this.setStateValue(Kn, _kn);
        this.setStateValue(Tn, _tn);
        this.setStateValue(Td, _td);
        this.setStateValue(Ti, _ti);
        this.setStateValue(x1, 0);
        this.setStateValue(tactual, 0);
        this.setSigma(Double.POSITIVE_INFINITY);
    }

    public void deltext(double e, Message x) {
        Vector solicitud;
        Iterator<Object> iteradorBarco = x.getValuesOnPort(puertoInBarco).iterator();
        Iterator<Object> iteradorModeloRef = x.getValuesOnPort(puertoInMRef).iterator();
        while (iteradorBarco.hasNext()) {
            solicitud = (Vector)iteradorBarco.next();
            Vector estados = (Vector)solicitud.get(0);
            this.setStateValue(psi, (Double)estados.get(2));
            this.setStateValue(r, (Double)estados.get(3));
        }
        while (iteradorModeloRef.hasNext()) {
            solicitud = (Vector)iteradorModeloRef.next();
            this.setStateValue(psir, (Double)solicitud.get(0));
            this.setStateValue(rr, (Double)solicitud.get(1));
            this.setStateValue(alfar, (Double)solicitud.get(2));
            this.setSigma(0.0);
        }
    }

    public void deltint() {
        this.setSigma(Double.POSITIVE_INFINITY);
    }

    public Message lambda() {
        this.avanzaTiempo();
        MessageImpl msg = new MessageImpl();
        Vector<Number> mensaje = new Vector<Number>(5, 0);
        mensaje.add(new Integer(2));
        mensaje.add(new Double(this.getStateValue(deltac).doubleValue()));
        msg.add(puertoOut, mensaje);
        return msg;
    }

    public void actualizaEstados(double[] estadosActuales) {
        this.setStateValue(x1, estadosActuales[0]);
    }

    public void avanzaTiempo() {
        this.actualizaEstados(this.integrador.integra(this, 5.0, this.getStateValue(tactual).doubleValue()));
        this.setStateValue(tactual, this.getStateValue(tactual).doubleValue() + 5.0);
        double vdeltac = 0.0;
        double valfar = this.getStateValue(alfar).doubleValue();
        double vrr = this.getStateValue(rr).doubleValue();
        double vr = this.getStateValue(r).doubleValue();
        double vkp = this.getStateValue(Kp).doubleValue();
        double vkn = this.getStateValue(Kn).doubleValue();
        double vtd = this.getStateValue(Td).doubleValue();
        double vtn = this.getStateValue(Tn).doubleValue();
        double vx1 = this.getStateValue(x1).doubleValue();
        double vpsir = this.getStateValue(psir).doubleValue();
        double vpsi = this.getStateValue(psi).doubleValue();
        vdeltac = vx1 + vkp * vtd * (vrr - vr) + 1.0 / vkn * (vtn * valfar + vrr) + vkp * this.normalizar(vpsir - vpsi);
        this.setStateValue(deltac, vdeltac);
    }

    public double[] dameControlActual() {
        return null;
    }

    public void imprimeEstado() {
        System.out.println("CONTROLADOR psir " + this.getStateValue(psir).doubleValue() + "rr " + this.getStateValue(rr).doubleValue() + "alfar " + this.getStateValue(alfar).doubleValue() + "psi " + this.getStateValue(psi).doubleValue() + "r " + this.getStateValue(r).doubleValue() + "deltac " + this.getStateValue(deltac).doubleValue() + "x1 " + this.getStateValue(x1).doubleValue());
    }

    public double[] dameDerivadas(double tiempo, double[] estados, double[] control) {
        double[] derivadas = new double[6];
        double vpsir = this.getStateValue(psir).doubleValue();
        double vpsi = this.getStateValue(psi).doubleValue();
        double vkp = this.getStateValue(Kp).doubleValue();
        double vti = this.getStateValue(Ti).doubleValue();
        derivadas[0] = vkp / vti * this.normalizar(vpsir - vpsi);
        return derivadas;
    }

    public double normalizar(double angulo) {
        double angulo_normalizado = angulo;
        if (angulo > Math.PI) {
            angulo_normalizado = this.normalizar(angulo - Math.PI * 2);
        }
        if (angulo < -Math.PI) {
            angulo_normalizado = this.normalizar(angulo + Math.PI * 2);
        }
        return angulo_normalizado;
    }

    public double[] dameEstadoActual() {
        double[] estado = new double[]{this.getStateValue(x1).doubleValue()};
        return estado;
    }
}

