/*
 * Decompiled with CFR 0.152.
 */
package proyectoSI.barcos;

import java.util.Vector;
import xdevs.kernel.modeling.AtomicStateImpl;
import xdevs.kernel.modeling.MessageImpl;
import xdevs.kernel.modeling.api.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PeticionesStateBarco
extends AtomicStateImpl {
    public static final String In = "in";
    private Message msg = new MessageImpl();
    private static final String estado = "Estado";
    public static final String PeticionBarco = "OutPeticionBarco";

    public PeticionesStateBarco(String name) {
        super(name);
        this.addInport(In);
        this.addOutport(PeticionBarco);
        this.addState(estado);
        this.setStateValue(estado, 0);
        this.setSigma(Double.POSITIVE_INFINITY);
    }

    @Override
    public void deltext(double arg0, Message arg1) {
        this.setSigma(0.0);
    }

    @Override
    public void deltint() {
        this.msg = new MessageImpl();
        this.setStateValue(estado, 0);
        this.setSigma(Double.POSITIVE_INFINITY);
    }

    @Override
    public Message lambda() {
        return this.msg;
    }

    public void reset(Vector<Double> posicion, Vector<Double> velocidad) {
        try {
            Vector<Number> peticion = new Vector<Number>();
            peticion.add(new Integer(1));
            peticion.add(posicion.get(0));
            peticion.add(posicion.get(1));
            peticion.add(velocidad.get(0));
            peticion.add(velocidad.get(1));
            peticion.add(velocidad.get(2));
            peticion.add(velocidad.get(3));
            this.msg.add(PeticionBarco, peticion);
            if ((this.getStateValue(estado).intValue() & (int)Math.pow(2.0, 0.0)) / (int)Math.pow(2.0, 0.0) != 1) {
                this.setStateValue(estado, this.getStateValue(estado).intValue() + (int)Math.pow(2.0, 0.0));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void cambiarVelocidad(double vref) {
        try {
            Vector<Number> a = new Vector<Number>();
            a.add(new Integer(3));
            a.add(vref);
            this.msg.add(PeticionBarco, a);
            if ((this.getStateValue(estado).intValue() & (int)Math.pow(2.0, 2.0)) / (int)Math.pow(2.0, 2.0) != 1) {
                this.setStateValue(estado, this.getStateValue(estado).intValue() + (int)Math.pow(2.0, 2.0));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void ponRutaReferencia(double ruta) {
        try {
            Vector<Number> a = new Vector<Number>();
            a.add(new Integer(102));
            a.add(ruta);
            this.msg.add(PeticionBarco, a);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void cambiarAnguloTimon(Double timon) {
        try {
            Vector<Number> a = new Vector<Number>();
            a.add(new Integer(2));
            a.add(timon);
            this.msg.add(PeticionBarco, a);
            if ((this.getStateValue(estado).intValue() & (int)Math.pow(2.0, 3.0)) / (int)Math.pow(2.0, 3.0) != 1) {
                this.setStateValue(estado, this.getStateValue(estado).intValue() + (int)Math.pow(2.0, 3.0));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void ponerFuel(Double fuel) {
        try {
            Vector<Number> a = new Vector<Number>();
            a.add(new Integer(4));
            a.add(fuel);
            this.msg.add(PeticionBarco, a);
            if ((this.getStateValue(estado).intValue() & (int)Math.pow(2.0, 5.0)) / (int)Math.pow(2.0, 5.0) != 1) {
                this.setStateValue(estado, this.getStateValue(estado).intValue() + (int)Math.pow(2.0, 5.0));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void iniciaSimulacion(Double fuel) {
        try {
            Vector<Number> a = new Vector<Number>();
            a.add(new Integer(5));
            a.add(fuel);
            this.msg.add(PeticionBarco, a);
            if ((this.getStateValue(estado).intValue() & (int)Math.pow(2.0, 6.0)) / (int)Math.pow(2.0, 6.0) != 1) {
                this.setStateValue(estado, this.getStateValue(estado).intValue() + (int)Math.pow(2.0, 6.0));
            }
        }
        catch (Exception e) {
            System.out.println("error en la peticion de iniciar simulacion");
        }
    }

    public void finSimulacion() {
        Vector<Integer> a = new Vector<Integer>();
        a.add(new Integer(6));
        this.msg.add(PeticionBarco, a);
        if ((this.getStateValue(estado).intValue() & (int)Math.pow(2.0, 7.0)) / (int)Math.pow(2.0, 7.0) != 1) {
            this.setStateValue(estado, this.getStateValue(estado).intValue() + (int)Math.pow(2.0, 7.0));
        }
    }

    public void destruirBarco() {
        Vector<Integer> a = new Vector<Integer>();
        a.add(new Integer(7));
        this.msg.add(PeticionBarco, a);
        if ((this.getStateValue(estado).intValue() & (int)Math.pow(2.0, 8.0)) / (int)Math.pow(2.0, 8.0) != 1) {
            this.setStateValue(estado, this.getStateValue(estado).intValue() + (int)Math.pow(2.0, 8.0));
        }
    }

    public void getPosicion() {
        Vector<Integer> a = new Vector<Integer>();
        a.add(new Integer(8));
        this.msg.add(PeticionBarco, a);
        if ((this.getStateValue(estado).intValue() & (int)Math.pow(2.0, 9.0)) / (int)Math.pow(2.0, 9.0) != 1) {
            this.setStateValue(estado, this.getStateValue(estado).intValue() + (int)Math.pow(2.0, 9.0));
        }
    }

    public void getVelocidad() {
        Vector<Integer> a = new Vector<Integer>();
        a.add(new Integer(9));
        this.msg.add(PeticionBarco, a);
        if ((this.getStateValue(estado).intValue() & (int)Math.pow(2.0, 10.0)) / (int)Math.pow(2.0, 10.0) != 1) {
            this.setStateValue(estado, this.getStateValue(estado).intValue() + (int)Math.pow(2.0, 10.0));
        }
    }

    public void getAngulos() {
        Vector<Integer> a = new Vector<Integer>();
        a.add(new Integer(10));
        this.msg.add(PeticionBarco, a);
        if ((this.getStateValue(estado).intValue() & (int)Math.pow(2.0, 11.0)) / (int)Math.pow(2.0, 11.0) != 1) {
            this.setStateValue(estado, this.getStateValue(estado).intValue() + (int)Math.pow(2.0, 11.0));
        }
    }

    public void getFuel() {
        Vector<Integer> a = new Vector<Integer>();
        a.add(new Integer(11));
        this.msg.add(PeticionBarco, a);
        if ((this.getStateValue(estado).intValue() & (int)Math.pow(2.0, 12.0)) / (int)Math.pow(2.0, 12.0) != 1) {
            this.setStateValue(estado, this.getStateValue(estado).intValue() + (int)Math.pow(2.0, 12.0));
        }
    }

    public void getEstado() {
        Vector a = new Vector();
        this.msg.add(PeticionBarco, a);
        if ((this.getStateValue(estado).intValue() & (int)Math.pow(2.0, 13.0)) / (int)Math.pow(2.0, 13.0) != 1) {
            this.setStateValue(estado, this.getStateValue(estado).intValue() + (int)Math.pow(2.0, 13.0));
        }
    }
}

