/*
 * Decompiled with CFR 0.152.
 */
package proyectoSI.grafico;

import java.awt.Component;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.glu.GLU;
import javax.swing.JFrame;
import proyectoSI.grafico.Dibujante;
import proyectoSI.grafico.ManagerVista;
import proyectoSI.grafico.estructura.Camara;
import proyectoSI.grafico.estructura.ManejadorRaton3D;
import proyectoSI.grafico.estructura.ManejadorTeclado3D;

public class ManagerGL3D
implements GLEventListener {
    private Camara _camara;
    private GLCanvas _lienzo;
    private Dibujante _dibujante;
    private ManagerVista _manager;
    private boolean _cambio;
    private float _xLeft;
    private float _xRight;
    private float _yBot;
    private float _yTop;
    private float _N;
    private float _F;

    public ManagerGL3D(ManagerVista manager, float xLeft, float xRight, float yBot, float yTop, float N, float F, JFrame contenedor, Dibujante dibujante, Camara camara) {
        this._xLeft = xLeft;
        this._xRight = xRight;
        this._yBot = yBot;
        this._yTop = yTop;
        this._N = N;
        this._F = F;
        this._camara = camara;
        this._lienzo = new GLCanvas();
        this._lienzo.addGLEventListener((GLEventListener)this);
        ManejadorRaton3D manejadorRaton = new ManejadorRaton3D(this);
        this._lienzo.addMouseListener((MouseListener)manejadorRaton);
        this._lienzo.addMouseMotionListener((MouseMotionListener)manejadorRaton);
        this._lienzo.addKeyListener((KeyListener)new ManejadorTeclado3D(this));
        contenedor.getContentPane().add((Component)this._lienzo, "Center");
        this._cambio = false;
        this._dibujante = dibujante;
        this._manager = manager;
    }

    public void init(GLAutoDrawable drawable) {
        GL gl = drawable.getGL();
        this._dibujante.inicializar(gl);
        GLU glu = new GLU();
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
        glu.gluLookAt(1000.0, 1000.0, 1000.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
        gl.glClearColor(0.6f, 0.7f, 0.8f, 1.0f);
        this._camara.fijarVistaPerspectiva(90.0f, 1.0f, this._N, this._F, gl);
        gl.glDisable(3553);
        gl.glDisable(2896);
        gl.glDisable(3042);
        gl.glEnable(2929);
        gl.glShadeModel(7425);
        gl.glClearDepth(1.0);
        gl.glDepthFunc(515);
        gl.glHint(3152, 4354);
    }

    public void reshape(GLAutoDrawable drawable, int x, int y, int ancho, int alto) {
        GL gl = drawable.getGL();
        gl.glMatrixMode(5888);
        float ratioViewPort = (float)ancho / (float)alto;
        gl.glViewport(0, 0, ancho, alto);
        float ratioVolVista = this._xRight / this._yTop;
        if (ratioVolVista >= ratioViewPort) {
            this._yTop = this._xRight / ratioViewPort;
            this._yBot = -this._yTop;
        } else {
            this._xRight = ratioViewPort * this._yTop;
            this._xLeft = -this._xRight;
        }
        this._camara.fijarVistaPerspectiva(90.0f, 1.0f, this._N, this._F, gl);
    }

    public void display(GLAutoDrawable drawable) {
        GL gl = drawable.getGL();
        gl.glMatrixMode(5888);
        if (this._cambio) {
            this._camara.fijarVistaPerspectiva(90.0f, 1.0f, this._N, this._F, gl);
            this._cambio = false;
        }
        this._camara.setModelViewMatrix(gl);
        gl.glClear(16640);
        this._dibujante.dibujar3D(drawable);
    }

    public void displayChanged(GLAutoDrawable drawable, boolean modeChage, boolean displayChanged) {
        System.out.println("DisplayChanged");
    }

    public void roll(float angulo) {
        this._camara.roll(angulo);
    }

    public void yaw(float angulo) {
        this._camara.yaw(angulo);
    }

    public void pitch(float angulo) {
        this._camara.pitch(angulo);
    }

    public void rollTo(float angulo) {
    }

    public void yawTo(float angulo) {
        this._camara.yawTo(angulo);
    }

    public void pitchTo(float angulo) {
        this._camara.pitchTo(angulo);
    }

    public void desplazar(float x, float y, float z) {
        this._camara.desplazar(x * 1.0f, y * 1.0f, z * 1.0f);
        this._manager.movimientoCamara(this._camara.get_eye());
    }

    public void goTo(float x, float y, float z) {
        this._camara.goTo(x, y, z);
        this._manager.movimientoCamara(this._camara.get_eye());
    }

    public void actualizar() {
        this._lienzo.repaint();
    }

    public void actualizarZoom(float xRight, float xLeft, float yTop, float yBot) {
        this._xRight = xRight;
        this._xLeft = xLeft;
        this._yTop = yTop;
        this._yBot = yBot;
        this._cambio = true;
    }

    public float getXRight() {
        return this._xRight;
    }

    public float getXLeft() {
        return this._xLeft;
    }

    public float getYTop() {
        return this._yTop;
    }

    public float getYBot() {
        return this._yBot;
    }

    public void movimientoRaton(float x, float y) {
        int alto = this._lienzo.getSize().height;
        int ancho = this._lienzo.getSize().width;
        if (x != 0.0f) {
            float pAncho = x / (float)ancho;
            this._camara.yaw(pAncho * 360.0f);
        }
        if (y != 0.0f) {
            float pAlto = y / (float)alto;
            this._camara.pitch(pAlto * 360.0f);
        }
    }

    public void desplazamientoRaton(float x, float y) {
        int alto = this._lienzo.getSize().height;
        int ancho = this._lienzo.getSize().width;
        float desX = (this._xRight - this._xLeft) * 100.0f / ((float)ancho / x);
        float desY = (this._yTop - this._yBot) * 100.0f / ((float)alto / y);
        this._camara.desplazar(desX, desY, 0.0f);
        this._manager.movimientoCamara(this._camara.get_eye());
    }
}

