/*
 * Decompiled with CFR 0.152.
 */
package proyectoSI.grafico;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import proyectoSI.modelo.ControladorAplicacion;

public class VentanaInicial
extends JFrame {
    private ControladorAplicacion _controlador;
    private JTextField _numeroAviones;
    private JTextField _numeroBarcos;
    private JTextField _numeroNaufragos;
    private static final long serialVersionUID = 1L;

    public VentanaInicial(ControladorAplicacion controlador) {
        this._controlador = controlador;
    }

    public void inicializar() {
        this.setSize(300, 300);
        this.setLayout(new GridLayout(5, 1, 10, 10));
        this._numeroAviones = new JTextField("1", 3);
        this._numeroBarcos = new JTextField("1", 3);
        this._numeroNaufragos = new JTextField("100", 3);
        this.setTitle("Configuraci\u00f3n de la simulaci\u00f3n");
        this.configurarPeticion(this._numeroAviones, "N\u00famero de aviones");
        this.configurarPeticion(this._numeroBarcos, "N\u00famero de barcos");
        this.configurarPeticion(this._numeroNaufragos, "N\u00famero de n\u00e1ufragos");
        this.add(new JPanel());
        this.configurarBotones();
    }

    private void configurarPeticion(JTextField campoTexto, String texto) {
        GridLayout grid = new GridLayout(1, 1);
        JPanel panelAviones = new JPanel(grid);
        GridBagLayout gridbag = new GridBagLayout();
        JPanel panelInterior = new JPanel(gridbag);
        panelAviones.add(panelInterior);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        JLabel etiqueta = new JLabel(texto, 0);
        gridbag.setConstraints(etiqueta, c);
        panelInterior.add(etiqueta);
        c.weightx = 0.0;
        campoTexto.setHorizontalAlignment(4);
        gridbag.setConstraints(campoTexto, c);
        panelInterior.add(campoTexto);
        this.add(panelAviones);
    }

    private void configurarBotones() {
        JPanel panelBotones = new JPanel(new GridLayout(1, 4, 10, 10));
        panelBotones.add(new JLabel());
        JButton botonAceptar = new JButton("Aceptar");
        this.establecerOyenteAceptar(botonAceptar);
        panelBotones.add(botonAceptar);
        JButton botonSalir = new JButton("Salir");
        this.establecerOyenteSalir(botonSalir);
        panelBotones.add(botonSalir);
        panelBotones.add(new JLabel());
        this.add(panelBotones);
    }

    private void establecerOyenteAceptar(AbstractButton aceptar) {
        aceptar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                int aviones = 0;
                int barcos = 0;
                int naufragos = 0;
                try {
                    aviones = Integer.parseInt(VentanaInicial.this._numeroAviones.getText());
                    barcos = Integer.parseInt(VentanaInicial.this._numeroBarcos.getText());
                    naufragos = Integer.parseInt(VentanaInicial.this._numeroNaufragos.getText());
                    VentanaInicial.this._controlador.inicializar(aviones, barcos, naufragos, 25200, true, false, 2000L, 100.0, 100000.0, 100000.0, 100000.0, 100000.0, 100000.0, 10000.0, false);
                    VentanaInicial.this.cerrar();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    VentanaInicial.this.error();
                }
            }
        });
    }

    private void cerrar() {
        this.dispose();
    }

    private void error() {
        JOptionPane.showMessageDialog(this, "Error en los campos", "Error", 0);
    }

    private void establecerOyenteSalir(AbstractButton salir) {
        salir.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                System.exit(0);
            }
        });
    }
}

