/*
 * Decompiled with CFR 0.152.
 */
package proyectoSI.grafico.estructura;

import javax.media.opengl.GL;
import proyectoSI.grafico.estructura.Cara;
import proyectoSI.grafico.estructura.Color;
import proyectoSI.grafico.estructura.ObjetoDegradado;
import proyectoSI.grafico.estructura.PV3D;
import proyectoSI.grafico.estructura.VerticeNormal;

public class TrianguloTerreno
extends ObjetoDegradado {
    private PV3D _p1;
    private PV3D _p2;
    private PV3D _p3;

    public TrianguloTerreno() {
        this._p1 = null;
        this._p2 = null;
        this._p3 = null;
    }

    public TrianguloTerreno(PV3D p1, PV3D p2, PV3D p3) {
        this._p1 = p1;
        this._p2 = p2;
        this._p3 = p3;
        int nVert = 3;
        int nNorm = 1;
        PV3D[] vert = new PV3D[nVert];
        PV3D[] norm = new PV3D[nNorm];
        Cara[] car = new Cara[nNorm];
        vert[0] = p1;
        vert[1] = p2;
        vert[2] = p3;
        Cara c = new Cara(3, new VerticeNormal[3]);
        c.getVerticeNormal()[0] = new VerticeNormal(0, 0);
        c.getVerticeNormal()[1] = new VerticeNormal(1, 0);
        c.getVerticeNormal()[2] = new VerticeNormal(2, 0);
        car[0] = c;
        this.setCaras(car);
        this.setNCaras(nNorm);
        this.setNNormales(nNorm);
        this.setNormales(norm);
        this.setNVertices(nVert);
        this.setVertices(vert);
        this.calcularNormalesNewell();
    }

    public void setP1(PV3D p1) {
        this._p1 = p1;
    }

    public void setP2(PV3D p2) {
        this._p2 = p2;
    }

    public void setP3(PV3D p3) {
        this._p3 = p3;
    }

    public PV3D getP1() {
        return this._p1;
    }

    public PV3D getP2() {
        return this._p2;
    }

    public PV3D getP3() {
        return this._p3;
    }

    public void inicializar() {
        int nVert = 3;
        int nNorm = 2;
        PV3D[] vert = new PV3D[nVert];
        PV3D[] norm = new PV3D[nNorm];
        Cara[] car = new Cara[nNorm];
        vert[0] = this._p1;
        vert[1] = this._p2;
        vert[2] = this._p3;
        Cara c = new Cara(3, new VerticeNormal[3]);
        c.getVerticeNormal()[0] = new VerticeNormal(0, 0);
        c.getVerticeNormal()[1] = new VerticeNormal(1, 0);
        c.getVerticeNormal()[2] = new VerticeNormal(2, 0);
        car[0] = c;
        c = new Cara(3, new VerticeNormal[3]);
        c.getVerticeNormal()[2] = new VerticeNormal(0, 1);
        c.getVerticeNormal()[1] = new VerticeNormal(1, 1);
        c.getVerticeNormal()[0] = new VerticeNormal(2, 1);
        car[1] = c;
        this.setCaras(car);
        this.setNCaras(nNorm);
        this.setNNormales(nNorm);
        this.setNormales(norm);
        this.setNVertices(nVert);
        this.setVertices(vert);
        this.calcularNormalesNewell();
    }

    public void dibujar3D(GL gl) {
        int nCaras = this.getNCaras();
        Cara[] caras = this.getCaras();
        PV3D[] vertices = this.getVertices();
        PV3D[] normales = this.getNormales();
        Color[] colores = this.getColores();
        gl.glPushMatrix();
        gl.glMultMatrixf(this.getTafin().getMatriz(), 0);
        for (int i = 0; i < nCaras; ++i) {
            gl.glBegin(9);
            for (int j = 0; j < caras[i].getNumVertices(); ++j) {
                int iV = caras[i].getVerticeNormal()[j].getVertice();
                int iN = caras[i].getVerticeNormal()[j].getNormal();
                gl.glColor3f(colores[iV].getRed(), colores[iV].getGreen(), colores[iV].getBlue());
                gl.glNormal3f(normales[iN].getX(), normales[iN].getY(), normales[iN].getZ());
                gl.glVertex3f(vertices[iV].getX(), vertices[iV].getY(), vertices[iV].getZ());
            }
            gl.glEnd();
        }
        gl.glPopMatrix();
    }
}

