/*
 * Decompiled with CFR 0.152.
 */
package proyectoSI.incidencias;

import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ProbabilidadNaufrago
implements Serializable {
    private int[][][] tablero;
    private int[] numNaufragosT;
    private double _tmin;
    private double _tmax;
    private double _varT;
    private double _nmin;
    private double _nmax;
    private double _varN;
    private double _emin;
    private double _emax;
    private double _varE;
    public static int Correcto = 1;
    public static int Incorrecto = 2;
    public static int Norte = 3;
    public static int Este = 4;
    public static int Tiempo = 5;
    private int numNaufragosTotales;

    public void imprimeEstado() {
        System.out.println("tmin " + this._tmin + "tmax " + this._tmax + "varT " + this._varT + "-" + "emin " + this._emin + "emax " + this._emax + "varE " + this._varE + "-" + "nmin " + this._nmin + "nmax " + this._nmax + "varN " + this._varN + "-");
    }

    public int[][][] dameTablero() {
        return this.tablero;
    }

    public ProbabilidadNaufrago(double tmin, double tmax, double varT, double nmin, double nmax, double varN, double emin, double emax, double varE) {
        this._tmin = tmin;
        this._tmax = tmax;
        this._varT = varT;
        int numT = (int)((this._tmax - this._tmin) / this._varT + 1.0);
        this._emin = emin;
        this._emax = emax;
        this._varE = varE;
        int numE = (int)((this._emax - this._emin) / this._varE + 1.0);
        this._nmin = nmin;
        this._nmax = nmax;
        this._varN = varN;
        int numN = (int)((this._nmax - this._nmin) / this._varN + 1.0);
        this.creaTablero(numT, numN, numE);
        this.numNaufragosT = new int[numT];
    }

    public double dameTiempoFinal() {
        return this._tmax + this._varT;
    }

    public static void main(String[] args) {
        ProbabilidadNaufrago prob = new ProbabilidadNaufrago(0.0, 14400.0, 3600.0, 0.0, 10000.0, 1000.0, 0.0, 10000.0, 1000.0);
        prob.escribirFichero("hola.xml");
    }

    public int[][][] creaTablero(int numt, int numn, int nume) {
        this.tablero = new int[numt][numn][nume];
        for (int i = 0; i < this.tablero.length; ++i) {
            for (int j = 0; j < this.tablero[i].length; ++j) {
                for (int k = 0; k < this.tablero[i][j].length; ++k) {
                    this.tablero[i][j][k] = 0;
                }
            }
        }
        return this.tablero;
    }

    public int leerFichero(String nombreFichero) {
        int devolver = Correcto;
        Document documento = this.readFile(nombreFichero);
        this.convertirDocumento(documento);
        return devolver;
    }

    public int escribirFichero(String nombreFichero) {
        int devolver = Correcto;
        Document doc = this.dameDocumento();
        this.writeFile(doc, nombreFichero);
        return devolver;
    }

    private void convertirDocumento(Document documento) {
        Element elem = documento.getDocumentElement();
        if (elem.hasChildNodes()) {
            Element elemento;
            int i;
            NodeList lista = elem.getElementsByTagName("naufragos");
            for (int i2 = 0; i2 < lista.getLength(); ++i2) {
                Element elemento2 = (Element)lista.item(i2);
                this.numNaufragosTotales = Integer.parseInt(elemento2.getAttribute("numnaufragos"));
            }
            lista = elem.getElementsByTagName("valores_tiempo");
            int numT = 0;
            int numE = 0;
            int numN = 0;
            for (i = 0; i < lista.getLength(); ++i) {
                elemento = (Element)lista.item(i);
                this._tmin = Double.valueOf(elemento.getAttribute("tmin"));
                this._tmax = Double.valueOf(elemento.getAttribute("tmax"));
                this._varT = Double.valueOf(elemento.getAttribute("varT"));
                numT = Integer.parseInt(elemento.getAttribute("longitud"));
            }
            lista = elem.getElementsByTagName("valores_este");
            for (i = 0; i < lista.getLength(); ++i) {
                elemento = (Element)lista.item(i);
                this._emin = Double.valueOf(elemento.getAttribute("emin"));
                this._emax = Double.valueOf(elemento.getAttribute("emax"));
                this._varE = Double.valueOf(elemento.getAttribute("varE"));
                numE = Integer.parseInt(elemento.getAttribute("longitud"));
            }
            lista = elem.getElementsByTagName("valores_norte");
            for (i = 0; i < lista.getLength(); ++i) {
                elemento = (Element)lista.item(i);
                this._nmin = Double.valueOf(elemento.getAttribute("nmin"));
                this._nmax = Double.valueOf(elemento.getAttribute("nmax"));
                this._varN = Double.valueOf(elemento.getAttribute("varN"));
                numN = Integer.parseInt(elemento.getAttribute("longitud"));
            }
            this.tablero = this.creaTablero(numT, numN, numE);
            for (i = 0; i < numT; ++i) {
                String nombreT = "tiempo" + new Integer(i).toString();
                lista = elem.getElementsByTagName(nombreT);
                for (int j = 0; j < lista.getLength(); ++j) {
                    Element elemento3 = (Element)lista.item(j);
                    for (int i2 = 0; i2 < numN; ++i2) {
                        String nombreN = "norte" + new Integer(i2).toString();
                        NodeList lista2 = elemento3.getElementsByTagName(nombreN);
                        for (int j2 = 0; j2 < lista.getLength(); ++j2) {
                            Element elemento2 = (Element)lista2.item(j2);
                            for (int i3 = 0; i3 < numE; ++i3) {
                                String nombreE = "este" + new Integer(i3).toString();
                                NodeList lista3 = elemento2.getElementsByTagName(nombreE);
                                for (int j3 = 0; j3 < lista.getLength(); ++j3) {
                                    Element elemento32 = (Element)lista3.item(j3);
                                    this.tablero[i][i2][i3] = Integer.valueOf(elemento32.getAttribute("numNaufragos"));
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private Document dameDocumento() {
        Document document = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.newDocument();
            Element root = document.createElement("xml");
            root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            document.appendChild(root);
            Element numNaufragosTotales = document.createElement("naufragos");
            numNaufragosTotales.setAttribute("numnaufragos", new Integer(this.numNaufragosTotales).toString());
            root.appendChild(numNaufragosTotales);
            Element tiempo = document.createElement("valores_tiempo");
            tiempo.setAttribute("tmin", new Double(this._tmin).toString());
            tiempo.setAttribute("tmax", new Double(this._tmax).toString());
            tiempo.setAttribute("varT", new Double(this._varT).toString());
            tiempo.setAttribute("longitud", new Integer(this.tablero.length).toString());
            root.appendChild(tiempo);
            Element norte = document.createElement("valores_norte");
            norte.setAttribute("nmin", new Double(this._nmin).toString());
            norte.setAttribute("nmax", new Double(this._nmax).toString());
            norte.setAttribute("varN", new Double(this._varN).toString());
            norte.setAttribute("longitud", new Integer(this.tablero[0].length).toString());
            root.appendChild(norte);
            Element este = document.createElement("valores_este");
            este.setAttribute("emin", new Double(this._emin).toString());
            este.setAttribute("emax", new Double(this._emax).toString());
            este.setAttribute("varE", new Double(this._varE).toString());
            este.setAttribute("longitud", new Integer(this.tablero[0][0].length).toString());
            root.appendChild(este);
            for (int i = 0; i < this.tablero.length; ++i) {
                Element tvar = document.createElement("tiempo" + new Integer(i).toString());
                tvar.setAttribute("numNaufragos", new Integer(this.numNaufragosT[i]).toString());
                for (int j = 0; j < this.tablero[i].length; ++j) {
                    Element nvar = document.createElement("norte" + new Integer(j).toString());
                    for (int k = 0; k < this.tablero[i][j].length; ++k) {
                        Element evar = document.createElement("este" + new Integer(k).toString());
                        evar.setAttribute("numNaufragos", new Integer(this.tablero[i][j][k]).toString());
                        nvar.appendChild(evar);
                    }
                    tvar.appendChild(nvar);
                }
                root.appendChild(tvar);
            }
        }
        catch (Exception e) {
            System.err.println("error en la generacion del xml de naufragos");
        }
        return document;
    }

    public double dameProbabilidad(double n, double e, double t) {
        double devolver = 0.0;
        int n_norm = this.normalizar(Norte, n);
        int e_norm = this.normalizar(Este, e);
        int t_norm = this.normalizar(Tiempo, t);
        int num_naufragos = this.tablero[t_norm][n_norm][e_norm];
        devolver = (double)num_naufragos / (double)this.numNaufragosT[t_norm];
        return devolver;
    }

    public Document readFile(String filename) {
        Document doc = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            doc = factory.newDocumentBuilder().parse(new File(filename));
        }
        catch (Exception e) {
            System.err.println("error en la lectura de fichero");
        }
        return doc;
    }

    public void writeFile(Document doc, String filename) {
        try {
            OutputFormat format = new OutputFormat("xml", "UTF-8", true);
            XMLSerializer serializer = new XMLSerializer(format);
            FileWriter xmlFile = new FileWriter(new File(filename));
            serializer.setOutputCharStream(xmlFile);
            serializer.serialize(doc);
            xmlFile.flush();
            xmlFile.close();
        }
        catch (Exception e) {
            System.err.println("error en la creacion del xml de naufragos");
        }
    }

    public void llegaNaufrago(double n, double e, double t) {
        int n_norm = this.normalizar(Norte, n);
        int e_norm = this.normalizar(Este, e);
        int t_norm = this.normalizar(Tiempo, t);
        this.numNaufragosT[t_norm] = this.numNaufragosT[t_norm] + 1;
        ++this.numNaufragosTotales;
        this.tablero[t_norm][n_norm][e_norm] = this.tablero[t_norm][n_norm][e_norm] + 1;
    }

    public int normalizar(int tipo, double t) {
        int normalizado = 0;
        if (tipo == Norte) {
            if (t > this._nmax) {
                t = this._nmax;
            }
            if (t < this._nmin) {
                t = this._nmin;
            }
            normalizado = (int)((t - this._nmin) / this._varN);
        } else if (tipo == Este) {
            if (t > this._emax) {
                t = this._emax;
            }
            if (t < this._emin) {
                t = this._emin;
            }
            normalizado = (int)((t - this._emin) / this._varE);
        } else if (tipo == Tiempo) {
            if (t > this._tmax) {
                t = this._tmax;
            }
            if (t < this._tmin) {
                t = this._tmin;
            }
            normalizado = (int)((t - this._tmin) / this._varT);
        }
        return normalizado;
    }

    public int[][][] getTablero() {
        return this.tablero;
    }

    public void setTablero(int[][][] tablero) {
        this.tablero = tablero;
    }

    public int[] getNumNaufragosT() {
        return this.numNaufragosT;
    }

    public void setNumNaufragosT(int[] numNaufragosT) {
        this.numNaufragosT = numNaufragosT;
    }

    public double get_tmin() {
        return this._tmin;
    }

    public void set_tmin(double _tmin) {
        this._tmin = _tmin;
    }

    public double get_tmax() {
        return this._tmax;
    }

    public void set_tmax(double _tmax) {
        this._tmax = _tmax;
    }

    public double get_varT() {
        return this._varT;
    }

    public void set_varT(double _vart) {
        this._varT = _vart;
    }

    public double get_nmin() {
        return this._nmin;
    }

    public void set_nmin(double _nmin) {
        this._nmin = _nmin;
    }

    public double get_nmax() {
        return this._nmax;
    }

    public void set_nmax(double _nmax) {
        this._nmax = _nmax;
    }

    public double get_varN() {
        return this._varN;
    }

    public void set_varN(double _varn) {
        this._varN = _varn;
    }

    public double get_emin() {
        return this._emin;
    }

    public void set_emin(double _emin) {
        this._emin = _emin;
    }

    public double get_emax() {
        return this._emax;
    }

    public void set_emax(double _emax) {
        this._emax = _emax;
    }

    public double get_varE() {
        return this._varE;
    }

    public void set_varE(double _vare) {
        this._varE = _vare;
    }

    public int getNumNaufragosTotales() {
        return this.numNaufragosTotales;
    }

    public void setNumNaufragosTotales(int numNaufragosTotales) {
        this.numNaufragosTotales = numNaufragosTotales;
    }
}

