/*
 * Decompiled with CFR 0.152.
 */
package proyectoSI.incidencias;

import java.io.Serializable;
import java.util.ArrayList;
import proyectoSI.incidencias.CasillaNaufrago;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProbabilidadNaufragoCasillas
implements Serializable {
    private double _tmin;
    private double _tmax;
    private double _varT;
    private double _varE;
    private double _varN;
    private ArrayList<ArrayList<CasillaNaufrago>> tablero;
    private int[] numNaufragosT;
    public static int Correcto = 1;
    public static int Incorrecto = 2;
    public static int Norte = 3;
    public static int Este = 4;
    public static int Tiempo = 5;
    private int numNaufragosTotales;

    public ArrayList<ArrayList<CasillaNaufrago>> dameTablero() {
        return this.tablero;
    }

    public ProbabilidadNaufragoCasillas(double tmin, double tmax, double varT, double varN, double varE) {
        this._tmin = tmin;
        this._tmax = tmax;
        this._varT = varT;
        int numT = (int)((this._tmax - this._tmin) / this._varT + 1.0);
        this._varE = varE;
        this._varN = varN;
        this.tablero = new ArrayList();
        this.numNaufragosT = new int[numT];
    }

    public double dameTiempoFinal() {
        return this._tmax + this._varT;
    }

    public double dameProbabilidad(double n, double e, double t) {
        double devolver = 0.0;
        int t_norm = this.normalizar(t);
        int num_naufragos = -1;
        int cont = 0;
        if (this.tablero.size() <= t_norm) {
            this.tablero.add(new ArrayList());
        }
        while (num_naufragos == -1 && cont < this.tablero.get(t_norm).size()) {
            num_naufragos = this.tablero.get(t_norm).get(cont).pertenece(n, e);
            if (num_naufragos != -1) continue;
            ++cont;
        }
        if (num_naufragos < 0) {
            num_naufragos = 0;
        }
        devolver = (double)num_naufragos / (double)this.numNaufragosT[t_norm];
        return devolver;
    }

    public void llegaNaufrago(double n, double e, double t) {
        int t_norm = this.normalizar(t);
        int num_naufragos = -1;
        int cont = 0;
        if (this.tablero.size() <= t_norm) {
            this.tablero.add(new ArrayList());
        }
        while (num_naufragos == -1 && cont < this.tablero.get(t_norm).size() - 1) {
            num_naufragos = this.tablero.get(t_norm).get(cont).pertenece(n, e);
            if (num_naufragos != -1) continue;
            ++cont;
        }
        if (num_naufragos < 0) {
            int kn = (int)(n / this._varN);
            int ke = (int)(e / this._varE);
            this.tablero.get(t_norm).add(new CasillaNaufrago((double)kn * this._varN, this._varN, (double)ke * this._varE, this._varE));
        } else {
            this.tablero.get(t_norm).get(cont).llegaNaufrago();
        }
        this.numNaufragosT[t_norm] = this.numNaufragosT[t_norm] + 1;
        ++this.numNaufragosTotales;
    }

    public int normalizar(double t) {
        int normalizado = 0;
        if (t > this._tmax) {
            t = this._tmax;
        }
        if (t < this._tmin) {
            t = this._tmin;
        }
        normalizado = (int)((t - this._tmin) / this._varT);
        return normalizado;
    }

    public int[] getNumNaufragosT() {
        return this.numNaufragosT;
    }

    public void setNumNaufragosT(int[] numNaufragosT) {
        this.numNaufragosT = numNaufragosT;
    }

    public double get_tmin() {
        return this._tmin;
    }

    public void set_tmin(double _tmin) {
        this._tmin = _tmin;
    }

    public double get_tmax() {
        return this._tmax;
    }

    public void set_tmax(double _tmax) {
        this._tmax = _tmax;
    }

    public double get_varT() {
        return this._varT;
    }

    public void set_varT(double _vart) {
        this._varT = _vart;
    }

    public double get_varN() {
        return this._varN;
    }

    public void set_varN(double _varn) {
        this._varN = _varn;
    }

    public double get_varE() {
        return this._varE;
    }

    public void set_varE(double _vare) {
        this._varE = _vare;
    }

    public int getNumNaufragosTotales() {
        return this.numNaufragosTotales;
    }

    public void setNumNaufragosTotales(int numNaufragosTotales) {
        this.numNaufragosTotales = numNaufragosTotales;
    }
}

