/*
 * Decompiled with CFR 0.152.
 */
package proyectoSI.otrosModelos;

import java.util.Random;
import proyectoSI.matematico.IFuncion;
import proyectoSI.matematico.IIntegrador;
import proyectoSI.matematico.RungeKutta;

public class Mar
implements IFuncion {
    private double gan_espectro_olas = 0.5;
    private double frec_pico_espectro = 1.2;
    private double amortig_relativo = 0.1;
    private double tiempo_integracion = 1.0;
    private double tiempo_actual = 0.0;
    private double dw = 0.0;
    private IIntegrador integrador;
    private Random randomizador = new Random();
    private double y = 0.0;
    private double dy = 0.0;
    private double w;

    public Mar() {
        this.integrador = new RungeKutta();
    }

    public double[] dameDerivadas(double tiempo, double[] estados, double[] control) {
        double[] derivadas = new double[]{estados[1], 6.0 * this.amortig_relativo * this.frec_pico_espectro * this.gan_espectro_olas * this.w - 2.0 * this.amortig_relativo * this.frec_pico_espectro * estados[1] - this.frec_pico_espectro * this.frec_pico_espectro * estados[0] + this.dw, this.randomizador.nextGaussian()};
        return derivadas;
    }

    public double[] dameEstadoActual() {
        double[] estado = new double[]{this.y, this.dy, this.dw};
        return estado;
    }

    public double[] dameSalidaActual() {
        double[] salida = new double[]{Math.PI * this.y / 180.0};
        return salida;
    }

    public double[] dameControlActual() {
        return null;
    }

    public void avanzaTiempo() {
        this.w = this.randomizador.nextGaussian();
        this.actualizaEstados(this.integrador.integra(this, this.tiempo_integracion, this.tiempo_actual));
        this.tiempo_actual += this.tiempo_integracion;
    }

    public void actualizaEstados(double[] estados) {
        this.y = estados[0];
        this.dy = estados[1];
        this.dw = estados[2];
    }

    public void imprimeEstados() {
        System.out.println(" y " + this.y);
        System.out.println(" dy " + this.dy);
        System.out.println(" dw " + this.dw);
    }

    public static void main(String[] args) {
        Mar mar = new Mar();
        for (int cont = 0; cont < 100; ++cont) {
            mar.imprimeEstados();
            mar.avanzaTiempo();
        }
    }
}

