/*
 * Decompiled with CFR 0.152.
 */
package xdevs.kernel.simulation;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import xdevs.kernel.modeling.MessageImpl;
import xdevs.kernel.modeling.api.Atomic;
import xdevs.kernel.modeling.api.Coupled;
import xdevs.kernel.modeling.api.Coupling;
import xdevs.kernel.modeling.api.Message;
import xdevs.kernel.simulation.SimulatorImpl;
import xdevs.kernel.simulation.api.Coordinator;
import xdevs.kernel.simulation.api.Simulator;

public class CoordinatorImpl
extends SimulatorImpl
implements Coordinator {
    protected HashMap<Atomic, Simulator> childs = new HashMap();

    public CoordinatorImpl(Coupled digraph) {
        super(digraph);
        Collection<Atomic> subModels = digraph.getComponents();
        for (Atomic subModel : subModels) {
            SimulatorImpl child;
            if (subModel instanceof Coupled) {
                child = new CoordinatorImpl((Coupled)subModel);
                child.setParent(this);
                this.childs.put(subModel, child);
                continue;
            }
            if (!(subModel instanceof Atomic)) continue;
            child = new SimulatorImpl(subModel);
            child.setParent(this);
            this.childs.put(subModel, child);
        }
        this.initialize(0.0);
    }

    public void initialize(double t) {
        for (Simulator child : this.childs.values()) {
            child.initialize(t);
        }
        this.tL = t;
        this.tN = t + this.ta(t);
    }

    public double ta(double t) {
        double tn = Double.POSITIVE_INFINITY;
        for (Simulator child : this.childs.values()) {
            if (!(child.getTN() < tn)) continue;
            tn = child.getTN();
        }
        return tn - t;
    }

    public void deltfcn(double t) {
        this.propagateInput();
        for (Simulator child : this.childs.values()) {
            child.deltfcn(t);
        }
        this.tL = t;
        this.tN = this.tL + this.ta(t);
        this.input = new MessageImpl();
    }

    public void lambda(double t) {
        if (t != this.tN) {
            this.output = new MessageImpl();
        }
        for (Simulator child : this.childs.values()) {
            child.lambda(t);
        }
        this.propagateOutput();
    }

    public void propagateInput() {
        Coupled digraph = (Coupled)this.model;
        Iterator<Coupling> itrEIC = null;
        for (Coupling c : digraph.getEICs()) {
            String portFrom = c.getNamePortFrom();
            String portTo = c.getNamePortTo();
            Atomic componentTo = c.getComponentTo();
            Message in = this.childs.get(componentTo).getInput();
            Message out = this.input;
            if (out.getValuesOnPort(portFrom).isEmpty()) continue;
            in.receive(portFrom, out, portTo);
        }
    }

    public void propagateOutput() {
        Message out;
        Message in;
        Coupled digraph = (Coupled)this.model;
        Iterator<Coupling> itrIC = null;
        for (Coupling c : digraph.getICs()) {
            String portFrom = c.getNamePortFrom();
            String portTo = c.getNamePortTo();
            Atomic componentFrom = c.getComponentFrom();
            Atomic componentTo = c.getComponentTo();
            in = this.childs.get(componentTo).getInput();
            out = this.childs.get(componentFrom).getOutput();
            if (out.getValuesOnPort(portFrom).isEmpty()) continue;
            in.receive(portFrom, out, portTo);
        }
        Iterator<Coupling> itrEOC = null;
        for (Coupling c : digraph.getEOCs()) {
            String portFrom = c.getNamePortFrom();
            String portTo = c.getNamePortTo();
            Atomic componentFrom = c.getComponentFrom();
            in = this.output;
            out = this.childs.get(componentFrom).getOutput();
            if (out.getValuesOnPort(portFrom).isEmpty()) continue;
            in.receive(portFrom, out, portTo);
        }
    }

    public void injectInput(double e, Message msg) {
        double t = this.tL + e;
        this.input = msg;
        this.deltfcn(t);
    }

    public void simulate(long numIterations) {
        long counter;
        double t = this.tN;
        for (counter = 1L; counter < numIterations && t < Double.POSITIVE_INFINITY; ++counter) {
            this.lambda(t);
            this.deltfcn(t);
            t = this.tN;
        }
        System.out.println(counter + " iterations.");
    }

    public void simulate(double interval) {
        double t = this.tN;
        double tF = t + interval;
        long counter = 0L;
        while (t < Double.POSITIVE_INFINITY && t < tF) {
            this.lambda(t);
            this.deltfcn(t);
            t = this.tN;
            ++counter;
        }
        System.out.println(counter + " iterations.");
    }
}

