/*
 * Decompiled with CFR 0.152.
 */
package xdevs.kernel.simulation;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import xdevs.kernel.modeling.MessageImpl;
import xdevs.kernel.modeling.api.AtomicDD;
import xdevs.kernel.modeling.api.CoupledDD;
import xdevs.kernel.modeling.api.CouplingDD;
import xdevs.kernel.modeling.api.DevsDess;
import xdevs.kernel.modeling.api.Message;
import xdevs.kernel.simulation.DDSimulatorImpl;
import xdevs.kernel.simulation.api.DDCoordinator;
import xdevs.kernel.simulation.api.DDSimulator;

public class DDCoordinatorImpl
extends DDSimulatorImpl
implements DDCoordinator {
    protected HashMap<AtomicDD, DDSimulator> childs = new HashMap();
    protected boolean state_event_detected = false;

    public DDCoordinatorImpl(CoupledDD digraph) {
        super(digraph);
        Collection<AtomicDD> subModels = digraph.getComponents();
        for (AtomicDD subModel : subModels) {
            DDSimulatorImpl child;
            if (subModel instanceof CoupledDD) {
                child = new DDCoordinatorImpl((CoupledDD)subModel);
                child.setParent(this);
                this.childs.put(subModel, child);
                continue;
            }
            if (!(subModel instanceof AtomicDD)) continue;
            child = new DDSimulatorImpl(subModel);
            child.setParent(this);
            this.childs.put(subModel, child);
        }
        this.initialize(0.0);
    }

    public void initialize(double t) {
        for (DDSimulator child : this.childs.values()) {
            child.initialize(t);
        }
        this.tL = t;
        this.tN = Double.POSITIVE_INFINITY;
    }

    public void deltfcnDiscr(double t) {
        this.propagateDiscrInput();
        for (DDSimulator child : this.childs.values()) {
            child.deltfcnDiscr(t);
        }
        this.tL = t;
        this.tN = Double.POSITIVE_INFINITY;
        this.inputDiscr = new MessageImpl();
    }

    public void deltfcnCont(double t, double h) {
        this.propagateContInput();
        for (DDSimulator child : this.childs.values()) {
            child.deltfcnCont(t, h);
        }
        this.tL = t;
        this.tN = Double.POSITIVE_INFINITY;
        this.inputCont = new MessageImpl();
    }

    public void lambdaDiscr(double t) {
        if (t != this.tN) {
            this.outputDiscr = new MessageImpl();
        }
        for (DDSimulator child : this.childs.values()) {
            child.lambdaDiscr(t);
        }
        this.propagateDiscrOutput();
    }

    public void lambdaCont(double t) {
        this.outputCont = new MessageImpl();
        for (DDSimulator child : this.childs.values()) {
            child.lambdaCont(t);
        }
        this.propagateContOutput();
    }

    public void lambdaStateEvent(double t, double h) {
        this.state_event_detected = false;
        this.outputStateEvent = new MessageImpl();
        for (DDSimulator child : this.childs.values()) {
            child.lambdaStateEvent(t, h);
        }
        this.stateEventDetected();
    }

    public void propagateDiscrInput() {
        CoupledDD digraph = (CoupledDD)this.model;
        Iterator<CouplingDD> itrEIC = null;
        for (CouplingDD c : digraph.getEICs()) {
            String portFrom = c.getNamePortFrom();
            String portTo = c.getNamePortTo();
            AtomicDD componentTo = c.getComponentTo();
            Message in = this.childs.get(componentTo).getInput(DevsDess.VALUE_TYPE.DISCR);
            Message out = this.inputDiscr;
            if (out.getValuesOnPort(portFrom).isEmpty()) continue;
            in.receive(portFrom, out, portTo);
        }
    }

    public void propagateContInput() {
        CoupledDD digraph = (CoupledDD)this.model;
        Iterator<CouplingDD> itrEIC = null;
        for (CouplingDD c : digraph.getEICs()) {
            String portFrom = c.getNamePortFrom();
            String portTo = c.getNamePortTo();
            AtomicDD componentTo = c.getComponentTo();
            Message in = this.childs.get(componentTo).getInput(DevsDess.VALUE_TYPE.CONT);
            Message out = this.inputCont;
            if (out.getValuesOnPort(portFrom).isEmpty()) continue;
            in.receive(portFrom, out, portTo);
        }
    }

    public void propagateDiscrOutput() {
        Message out;
        Message in;
        CoupledDD digraph = (CoupledDD)this.model;
        Iterator<CouplingDD> itrIC = null;
        for (CouplingDD c : digraph.getICs()) {
            String portFrom = c.getNamePortFrom();
            String portTo = c.getNamePortTo();
            AtomicDD componentFrom = c.getComponentFrom();
            AtomicDD componentTo = c.getComponentTo();
            in = this.childs.get(componentTo).getInput(DevsDess.VALUE_TYPE.DISCR);
            out = this.childs.get(componentFrom).getOutput(DevsDess.VALUE_TYPE.DISCR);
            if (out.getValuesOnPort(portFrom).isEmpty()) continue;
            in.receive(portFrom, out, portTo);
        }
        Iterator<CouplingDD> itrEOC = null;
        for (CouplingDD c : digraph.getEOCs()) {
            String portFrom = c.getNamePortFrom();
            String portTo = c.getNamePortTo();
            AtomicDD componentFrom = c.getComponentFrom();
            in = this.outputDiscr;
            out = this.childs.get(componentFrom).getOutput(DevsDess.VALUE_TYPE.DISCR);
            if (out.getValuesOnPort(portFrom).isEmpty()) continue;
            in.receive(portFrom, out, portTo);
        }
    }

    public void propagateContOutput() {
        Message out;
        Message in;
        CoupledDD digraph = (CoupledDD)this.model;
        Iterator<CouplingDD> itrIC = null;
        for (CouplingDD c : digraph.getICs()) {
            String portFrom = c.getNamePortFrom();
            String portTo = c.getNamePortTo();
            AtomicDD componentFrom = c.getComponentFrom();
            AtomicDD componentTo = c.getComponentTo();
            in = this.childs.get(componentTo).getInput(DevsDess.VALUE_TYPE.CONT);
            out = this.childs.get(componentFrom).getOutput(DevsDess.VALUE_TYPE.CONT);
            if (out.getValuesOnPort(portFrom).isEmpty()) continue;
            in.receive(portFrom, out, portTo);
        }
        Iterator<CouplingDD> itrEOC = null;
        for (CouplingDD c : digraph.getEOCs()) {
            String portFrom = c.getNamePortFrom();
            String portTo = c.getNamePortTo();
            AtomicDD componentFrom = c.getComponentFrom();
            in = this.outputCont;
            out = this.childs.get(componentFrom).getOutput(DevsDess.VALUE_TYPE.CONT);
            if (out.getValuesOnPort(portFrom).isEmpty()) continue;
            in.receive(portFrom, out, portTo);
        }
    }

    public void stateEventDetected() {
        for (DDSimulator child : this.childs.values()) {
            Message se = child.getOutputStateEvent();
            if (se.isEmpty()) continue;
            Iterator<Object> itrN = se.getValuesOnPort("se").iterator();
            double tNc = (Double)itrN.next();
            if (tNc < this.tN) {
                this.tN = tNc;
            }
            this.state_event_detected = true;
        }
    }

    public void simulate(long numIterations, double stepSize, double numSteps) {
        long counter;
        double t = this.tL;
        double h = stepSize;
        long s = 0L;
        for (counter = 0L; counter < numIterations; ++counter) {
            s = 0L;
            while (t < this.tN && (double)s < numSteps) {
                double dH = t + h < this.tN ? h : this.tN - t;
                this.lambdaCont(t);
                this.deltfcnCont(t, dH);
                this.lambdaStateEvent(t, dH);
                if (this.state_event_detected) {
                    // empty if block
                }
                t += dH;
                ++s;
            }
            this.lambdaDiscr(this.tN);
            this.deltfcnDiscr(this.tN);
        }
        System.out.println(counter + " iterations.");
    }

    public void simulate(double interval, double stepSize, double numSteps) {
        double t = this.tN;
        double h = stepSize;
        double tF = t + interval;
        long counter = 0L;
        long s = 0L;
        while (t < Double.POSITIVE_INFINITY && t < tF) {
            s = 0L;
            while (t < this.tN && (double)s < numSteps) {
                double dH = t + h < this.tN ? h : this.tN - t;
                this.lambdaCont(t);
                this.deltfcnCont(t, dH);
                this.lambdaStateEvent(t, dH);
                if (this.state_event_detected) {
                    // empty if block
                }
                t += dH;
                ++s;
            }
            this.lambdaDiscr(this.tN);
            this.deltfcnDiscr(this.tN);
            ++counter;
        }
        System.out.println(counter + " iterations.");
    }
}

