/*
 * Decompiled with CFR 0.152.
 */
package xdevs.kernel.simulation;

import xdevs.kernel.modeling.MessageImpl;
import xdevs.kernel.modeling.api.Atomic;
import xdevs.kernel.modeling.api.Message;
import xdevs.kernel.simulation.api.Coordinator;
import xdevs.kernel.simulation.api.Simulator;

public class SimulatorImpl
implements Simulator {
    protected Coordinator parent = null;
    protected Atomic model;
    protected Message input;
    protected Message output;
    protected double tL;
    protected double tN;

    public SimulatorImpl(Atomic model) {
        this.model = model;
        this.input = new MessageImpl();
        this.output = new MessageImpl();
    }

    public void initialize(double t) {
        this.tL = t;
        this.tN = t + this.ta(t);
    }

    public double ta(double t) {
        return this.model.ta();
    }

    public void deltfcn(double t) {
        if (this.input.isEmpty() && t != this.tN) {
            return;
        }
        if (!this.input.isEmpty() && t == this.tN) {
            double e = t - this.tL;
            this.model.deltcon(e, this.input);
        } else if (this.input.isEmpty() && t == this.tN) {
            this.model.deltint();
        } else if (!this.input.isEmpty() && t != this.tN) {
            double e = t - this.tL;
            this.model.setSigma(this.model.getSigma() - e);
            this.model.deltext(e, this.input);
        }
        this.tL = t;
        this.tN = this.tL + this.model.ta();
        this.input = new MessageImpl();
    }

    public void lambda(double t) {
        if (t != this.tN) {
            this.output = new MessageImpl();
        } else {
            this.output = this.model.lambda();
            if (this.output == null) {
                this.output = new MessageImpl();
            }
        }
    }

    public void setTL(double tL) {
        this.tL = tL;
    }

    public void setTN(double tN) {
        this.tN = tN;
    }

    public double getTL() {
        return this.tL;
    }

    public double getTN() {
        return this.tN;
    }

    public Atomic getModel() {
        return this.model;
    }

    public void setParent(Coordinator parent) {
        this.parent = parent;
    }

    public Coordinator getParent() {
        return this.parent;
    }

    public Message getInput() {
        return this.input;
    }

    public Message getOutput() {
        return this.output;
    }
}

