/*
 * Decompiled with CFR 0.152.
 */
package editor.view;

import editor.ext.jgraph.AtomicNode;
import editor.ext.jgraph.MyComplexNode;
import editor.ext.jgraph.MyPort;
import editor.ext.model.EntrySimModTable;
import editor.ext.model.PropAttManager;
import editor.view.MainWindow;
import editor.view.ShadowBorder;
import editor.view.actions.MyMarqueeHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableModel;
import org.jgraph.event.GraphModelEvent;
import org.jgraph.event.GraphModelListener;
import org.jgraph.event.GraphSelectionEvent;
import org.jgraph.event.GraphSelectionListener;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellViewFactory;
import org.jgraph.graph.DefaultCellViewFactory;
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.Edge;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.GraphSelectionModel;
import org.jgraph.graph.ParentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelWindow
extends JScrollPane
implements GraphSelectionListener,
GraphModelListener {
    MyComplexNode graph;
    GraphModel model;
    GraphLayoutCache view;
    Vector cells;
    MainWindow parentGUI;
    boolean modified;
    PropAttManager manager = new PropAttManager();

    public ModelWindow(MainWindow parentGUI, AtomicNode initialCells) {
        this.model = new DefaultGraphModel();
        GraphLayoutCache layoutCache = new GraphLayoutCache(this.model, (CellViewFactory)new DefaultCellViewFactory(), true);
        this.graph = new MyComplexNode(this.model, layoutCache);
        this.graph.setMarqueeHandler(new MyMarqueeHandler(this));
        this.graph.setInvokesStopCellEditing(true);
        this.parentGUI = parentGUI;
        this.initialize(initialCells);
    }

    public MyComplexNode getGraph() {
        return this.graph;
    }

    public void ungroup() {
        System.out.println("**********ungroup()**********");
        GraphSelectionModel gsm = this.graph.getSelectionModel();
        Object[] cells = gsm.getSelectionCells();
        this.graph.getGraphLayoutCache().ungroup(cells);
    }

    public void collapse() {
        System.out.println("**********collapse()**********");
        this.group();
        GraphSelectionModel gsm = this.graph.getSelectionModel();
        Object[] cells = gsm.getSelectionCells();
        this.graph.getGraphLayoutCache().collapse(cells);
    }

    public void group() {
        System.out.println("**********group() 2**********");
        GraphSelectionModel gsm = this.graph.getSelectionModel();
        Object[] children = gsm.getSelectionCells();
        children = this.graph.order(children);
        if (children != null && children.length > 0) {
            double gs2 = 2.0 * this.graph.getGridSize();
            Rectangle2D collapsedBounds = this.graph.getCellBounds(children);
            collapsedBounds.setFrame(collapsedBounds.getX(), collapsedBounds.getY(), Math.max(collapsedBounds.getWidth(), gs2), Math.max(collapsedBounds.getHeight(), gs2));
            this.graph.snap(collapsedBounds);
            DefaultGraphCell group = this.createGroupCell(collapsedBounds);
            if (group != null && children != null && children.length > 0) {
                ParentMap pm = new ParentMap();
                for (int i = 0; i < children.length; ++i) {
                    pm.addEntry(children[i], (Object)group);
                }
                this.graph.getGraphLayoutCache().insert(new Object[]{group}, null, null, pm);
            }
        }
    }

    public void newView() {
        GraphSelectionModel gsm = this.graph.getSelectionModel();
        AtomicNode selectedCell = (AtomicNode)((Object)gsm.getSelectionCell());
        AtomicNode cellClone = (AtomicNode)((Object)selectedCell.clone());
        this.parentGUI.addNewCanvas(cellClone);
        GraphModel gm = this.graph.getModel();
        AttributeMap att = gm.getAttributes(gsm.getSelectionCell());
        this.manager.updateSelectedmodel(gsm, att);
        this.updatePropertiesTable();
        this.updateAttributesTable();
    }

    protected DefaultGraphCell createGroupCell(Rectangle2D collapsedBounds) {
        DefaultGraphCell group = this.createGroupCell();
        group.addPort();
        GraphConstants.setInset((Map)group.getAttributes(), (int)10);
        GraphConstants.setBackground((Map)group.getAttributes(), (Color)new Color(71, 176, 107));
        GraphConstants.setBorderColor((Map)group.getAttributes(), (Color)Color.black);
        GraphConstants.setOpaque((Map)group.getAttributes(), (boolean)true);
        GraphConstants.setBorder((Map)group.getAttributes(), (Border)ShadowBorder.getSharedInstance());
        GraphConstants.setBounds((Map)group.getAttributes(), (Rectangle2D)collapsedBounds);
        return group;
    }

    protected DefaultGraphCell createGroupCell() {
        AtomicNode complex = new AtomicNode("COMPLEX");
        System.out.println("_-_-_-_-_-_-_-_-_-_-_-_-_-_-");
        System.out.println(complex.children());
        complex.setComplex(new MyComplexNode((GraphModel)new DefaultGraphModel()));
        return complex;
    }

    public void expand() {
        System.out.println("**********expand()**********");
        this.graph.getGraphLayoutCache().expand(this.graph.getSelectionCells());
        this.ungroup();
    }

    private void initialize(AtomicNode initialCells) {
        this.graph.getSelectionModel().addGraphSelectionListener((GraphSelectionListener)this);
        this.graph.getModel().addGraphModelListener((GraphModelListener)this);
        this.graph.setPortsVisible(!this.graph.isPortsVisible());
        if (initialCells != null) {
            this.graph.insertSubModel(initialCells);
            this.expand();
        } else {
            this.graph.insertDefaultSubModel("SinWave", "resources/icons/sine.png", 0, 1);
            this.graph.insertDefaultSubModel("Integrator", "resources/icons/integrator.png", 1, 1);
            this.graph.insertDefaultSubModel("Scope", "resources/icons/scope.png", 1, 0);
            try {
                this.graph.insertAtomicDefaultSubModel("mery");
            }
            catch (Exception e) {
                System.out.println("Can't create default atomic model");
            }
            AtomicNode nodoSin = this.graph.findSubModel("SinWave");
            AtomicNode nodoInt = this.graph.findSubModel("Integrator");
            AtomicNode nodoSco = this.graph.findSubModel("Scope");
            this.graph.insertConnection(nodoSin, nodoInt, 0, 0);
            this.graph.insertConnection(nodoInt, nodoSco, 1, 0);
        }
        this.setViewportView((Component)((Object)this.graph));
    }

    private void initialize(MyComplexNode initComplex) {
        this.graph.getSelectionModel().addGraphSelectionListener((GraphSelectionListener)this);
        this.graph.getModel().addGraphModelListener((GraphModelListener)this);
        this.graph.setPortsVisible(!this.graph.isPortsVisible());
        if (initComplex != null) {
            this.graph = initComplex;
            this.expand();
        } else {
            this.graph.insertDefaultSubModel("SinWave", "icons/sine.png", 0, 1);
            this.graph.insertDefaultSubModel("Integrator", "icons/integrator.png", 1, 1);
            this.graph.insertDefaultSubModel("Scope", "icons/scope.png", 1, 0);
            try {
                this.graph.insertAtomicDefaultSubModel("mery");
            }
            catch (Exception e) {
                System.out.println("Can't create default atomic model");
            }
            AtomicNode nodoSin = this.graph.findSubModel("SinWave");
            AtomicNode nodoInt = this.graph.findSubModel("Integrator");
            AtomicNode nodoSco = this.graph.findSubModel("Scope");
            this.graph.insertConnection(nodoSin, nodoInt, 0, 0);
            this.graph.insertConnection(nodoInt, nodoSco, 1, 0);
        }
        this.setViewportView((Component)((Object)this.graph));
    }

    public void insertCell(String label) {
        this.graph.insertDefaultSubModel(label, null, 1, 1);
    }

    public void insertCell(String label, String imgPath, int inPorts, int outPorts) {
        this.graph.insertDefaultSubModel(label, imgPath, inPorts, outPorts);
    }

    public void insertCell(String label, Hashtable<String, EntrySimModTable> att) {
        try {
            this.graph.insertAtomicDefaultSubModel(label, att);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void remove() {
        if (!this.graph.isSelectionEmpty()) {
            Object[] cells = this.graph.getSelectionCells();
            cells = this.graph.getDescendants(cells);
            ArrayList edges = new ArrayList();
            for (int i = 0; i < cells.length; ++i) {
                if (!this.graph.getModel().isPort(cells[i])) continue;
                Iterator it = this.graph.getModel().edges(cells[i]);
                while (it.hasNext()) {
                    edges.add(it.next());
                }
            }
            this.graph.getModel().remove(edges.toArray());
            this.graph.getModel().remove(cells);
        }
    }

    public void editFromOI(TableModel model) {
    }

    public void addIPort() {
        this.manager.addGenericInPort();
        this.updateAttributesTable();
    }

    public void addOPort() {
        this.manager.addGenericOutPort();
        this.updateAttributesTable();
    }

    public void connect() {
        this.graph.setPortsVisible(!this.graph.isPortsVisible());
    }

    public void connect(MyPort source, MyPort target) {
        this.graph.insertConnection(source, target);
    }

    public void edit() {
        if (this.graph.getSelectionCount() > 1) {
            this.parentGUI.editAtomicWindow();
        }
    }

    protected DefaultEdge createEdge() {
        DefaultEdge edge = new DefaultEdge();
        edge.getAttributes().applyMap(this.createEdgeAttributes());
        return edge;
    }

    public Map createEdgeAttributes() {
        Hashtable map = new Hashtable();
        GraphConstants.setLabelAlongEdge(map, (boolean)true);
        GraphConstants.setLineStyle(map, (int)11);
        GraphConstants.setRouting(map, (Edge.Routing)GraphConstants.ROUTING_SIMPLE);
        GraphConstants.setLineEnd(map, (int)1);
        GraphConstants.setEndFill(map, (boolean)true);
        return map;
    }

    protected DefaultGraphCell createDefaultGraphCell(String label) {
        AtomicNode cell = new AtomicNode(label);
        cell.addGenericInPort();
        cell.addGenericOutPort();
        return cell;
    }

    protected void updatePropertiesTable() {
        JTable table = this.parentGUI.getPropertiesTable();
        table.setModel(this.manager.buildPropTableModel(this.parentGUI.getColumnsPropertiesIds()));
    }

    protected void updateAttributesTable() {
        JTable table = this.parentGUI.getAttributesTable();
        table.setModel(this.manager.buildAttTableModel(this.parentGUI.getColumnsAttributesIds()));
    }

    private Object extractModelAtt(GraphSelectionModel gsm, String string) {
        return null;
    }

    public void valueChanged(GraphSelectionEvent gse) {
        GraphSelectionModel gsm;
        boolean enabled = !this.graph.isSelectionEmpty();
        this.parentGUI.getCopyButton().setEnabled(enabled);
        this.parentGUI.getCutButton().setEnabled(enabled);
        this.parentGUI.getRemoveButton().setEnabled(enabled);
        this.parentGUI.getOpenModelButton().setEnabled(enabled);
        this.parentGUI.getAddIPortButton().setEnabled(enabled);
        this.parentGUI.getAddOPortButton().setEnabled(enabled);
        this.parentGUI.getGroupButton().setEnabled(enabled);
        this.parentGUI.getUngroupButton().setEnabled(enabled);
        this.parentGUI.getCollapseButton().setEnabled(enabled);
        this.parentGUI.getExpandButton().setEnabled(enabled);
        if (this.graph.getSelectionCount() <= 1) {
            this.parentGUI.getGroupButton().setEnabled(false);
            this.parentGUI.getCollapseButton().setEnabled(false);
        } else if (this.graph.getSelectionCount() == 1) {
            gsm = this.graph.getSelectionModel();
            Object[] cells2 = gsm.getSelectionCells();
            System.out.print("Seleccionadas: ");
            for (int i = 0; i < cells2.length; ++i) {
                System.out.print(cells2[i] + ", ");
            }
            System.out.println();
        }
        gsm = this.graph.getSelectionModel();
        GraphModel gm = this.graph.getModel();
        AttributeMap att = gm.getAttributes(gsm.getSelectionCell());
        this.manager.updateSelectedmodel(gsm, att);
        this.updatePropertiesTable();
        this.updateAttributesTable();
    }

    public void graphChanged(GraphModelEvent e) {
        GraphSelectionModel gsm = this.graph.getSelectionModel();
        GraphModel gm = this.graph.getModel();
        AttributeMap att = gm.getAttributes(gsm.getSelectionCell());
        this.manager.updateSelectedmodel(gsm, att);
        this.updatePropertiesTable();
        this.updateAttributesTable();
    }

    public JPopupMenu createPopupMenu(Point pt, Object cell) {
        return this.parentGUI.createPopupMenu(pt, cell);
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }
}

