/*
 * Decompiled with CFR 0.152.
 */
package lib.atomic.dynamic.continuous;

import java.util.Iterator;
import lib.atomic.dynamic.IDynSys;
import xdevs.kernel.modeling.AtomicImpl;
import xdevs.kernel.modeling.MessageImpl;
import xdevs.kernel.modeling.api.Message;

public class MEALY_SScsys
extends AtomicImpl {
    public static final String out = "out";
    public static final String outx = "outx";
    public static final String in = "in";
    public static final String clock = "clock";
    private IDynSys mymodel;
    private Double[] x;
    private Double[] u;
    private Double[] uold;
    private Double[] y;
    private double dt;
    private String utype;
    static final int YES = 1;
    static final int NO = 0;
    private int debug = 1;
    private double tiempo = 0.0;

    public MEALY_SScsys(String name, IDynSys model) {
        super(name);
        this.addInport(in);
        this.addInport(clock);
        this.addOutport(out);
        this.addOutport(outx);
        this.mymodel = model;
        this.u = new Double[this.mymodel.getNu()];
        this.uold = new Double[this.mymodel.getNu()];
        this.x = new Double[this.mymodel.getNx()];
        this.x = this.mymodel.getState();
        super.setPhase("initial");
        super.setSigma(Double.POSITIVE_INFINITY);
    }

    public double ta(double t) {
        return super.getSigma();
    }

    public void deltext(double e, Message x) {
        Object uu = null;
        Iterator<Object> itr = x.getValuesOnPort(in).iterator();
        if (itr.hasNext()) {
            uu = itr.next();
        }
        if (uu != null) {
            if (super.getPhase() == "initial") {
                this.utype = this.getTypeUu(uu);
                this.getSignalU(this.utype, uu);
                this.uold = (Double[])this.u.clone();
            } else {
                this.uold = (Double[])this.u.clone();
                this.getSignalU(this.utype, uu);
                super.setPhase("new");
            }
            super.setSigma(0.0);
            this.dt = e;
        }
        Object clk = null;
        itr = x.getValuesOnPort(clock).iterator();
        if (itr.hasNext()) {
            clk = itr.next();
        }
        if (clk != null) {
            super.setSigma(0.0);
            super.setPhase("transitory");
        }
        if (this.debug == 1) {
            System.out.println("MEALY_SScsys deltext t: " + (this.tiempo + e) + ", " + super.getPhase());
            for (int i = 0; i < this.u.length; ++i) {
                System.out.println("u(" + i + "): " + this.u[i]);
            }
        }
    }

    public void deltint() {
        super.setSigma(Double.POSITIVE_INFINITY);
        super.setPhase("old");
        this.tiempo += this.dt;
        this.dt = this.mymodel.getSampling();
        if (this.debug == 1) {
            System.out.println("MEALY_SScsys deltin  tnext: " + this.tiempo);
            for (int i = 0; i < this.x.length; ++i) {
                System.out.println(" x(" + (i + 1) + "): " + this.x[i]);
            }
        }
    }

    public Message lambda() {
        if (super.getPhase() == "initial") {
            this.y = this.mymodel.gxut(this.dt, this.x, this.u);
            super.setPhase("new");
        } else {
            double h = super.getPhase() == "new" ? this.dt : this.mymodel.getSampling();
            this.x = this.mymodel.update(h, this.x, this.uold);
            this.y = this.mymodel.gxut(this.dt, this.x, this.u);
            this.uold = (Double[])this.u.clone();
        }
        MessageImpl msg = new MessageImpl();
        msg.add(out, this.y);
        msg.add(outx, this.x);
        if (this.debug == 1) {
            System.out.println("MEALY_SScsys lambda t: " + this.tiempo + ", " + super.getPhase() + " s: " + this.ta());
            for (int i = 0; i < this.y.length; ++i) {
                System.out.println("y(" + i + "): " + this.y[i]);
            }
        }
        return msg;
    }

    public void deltcon(double e, Message x) {
        this.deltext(e, x);
        this.deltint();
    }

    private String getTypeUu(Object uu) {
        String uutype = uu.getClass().getCanonicalName();
        if (uutype.equals("java.lang.Double[]")) {
            uutype = "array";
        } else if (uutype.equals("java.lang.Double")) {
            uutype = "Double";
        } else {
            uutype = " ";
            System.out.println(super.getName() + ": Error tipo de dato de entrada.");
            this.u[0] = 0.0;
        }
        return uutype;
    }

    private void getSignalU(String utype, Object uu) {
        if (utype == "array") {
            System.arraycopy(uu, 0, this.u, 0, this.u.length);
        } else if (utype == "Double") {
            this.u[0] = (Double)uu;
        }
    }
}

