/*
 * Decompiled with CFR 0.152.
 */
package lib.atomic.dynamic.continuous;

import lib.atomic.dynamic.IDynSys;
import lib.atomic.dynamic.Integrator;
import lib.atomic.dynamic.Sizes;

public class SSclsys
implements IDynSys {
    private Double[][] A;
    private Double[][] B;
    private Double[][] C;
    private Double[][] D;
    private int n;
    private int m;
    private int p;
    private Double[] x;
    private Double[] y;
    final double DEFAULT_H = 0.01;
    private double h = 0.01;
    private int k = 0;

    public SSclsys() {
        this.A[0][0] = 0.0;
        this.B[0][0] = 1.0;
        this.C[0][0] = 1.0;
        this.D[0][0] = 0.0;
        this.n = this.A.length;
        this.m = this.B[0].length;
        this.p = this.C.length;
        this.x[0] = 0.0;
        this.y[0] = 0.0;
    }

    public SSclsys(Double[][] A, Double[][] B, Double[][] C, Double[][] D) {
        this.A = A;
        this.B = B;
        this.C = C;
        this.D = D;
        this.n = A.length;
        this.m = B[0].length;
        this.p = C.length;
        this.x = new Double[this.n];
        this.y = new Double[this.p];
    }

    public SSclsys(Double[][] A, Double[][] B, Double[][] C, Double[][] D, Double[] x0) {
        this(A, B, C, D);
        for (int i = 0; i < this.n; ++i) {
            this.x[i] = x0[i];
        }
    }

    public SSclsys(Double[][] A, Double[][] B, Double[][] C, Double[][] D, Double[] x0, double h) {
        this(A, B, C, D, x0);
        this.h = Math.abs(h) > 0.0 ? Math.abs(h) : 0.1;
    }

    public Double[] getState() {
        return this.x;
    }

    public Double[] getOutput() {
        return this.y;
    }

    public int getNx() {
        return this.n;
    }

    public int getNu() {
        return this.m;
    }

    public int getNy() {
        return this.p;
    }

    public Sizes getSizes() {
        Sizes sizes = new Sizes();
        sizes.Nxc = this.n;
        sizes.Nu = this.m;
        sizes.Ny = this.p;
        return sizes;
    }

    public double getSampling() {
        return this.h;
    }

    public double getTime() {
        return (double)this.k * this.h;
    }

    public Double[] update(double dt, Double[] xt, Double[] ut) {
        Double[] xx = new Double[xt.length];
        xx = Integrator.rk4(this, (double)this.k * this.h, this.h, xt, ut, xt.length);
        this.x = (Double[])xx.clone();
        ++this.k;
        return xx;
    }

    public Double[] fxut(double dt, Double[] xt, Double[] ut) {
        Double[] dx = new Double[xt.length];
        for (int i = 0; i < this.n; ++i) {
            int j;
            dx[i] = 0.0;
            for (j = 0; j < this.n; ++j) {
                dx[i] = dx[i] + this.A[i][j] * xt[j];
            }
            for (j = 0; j < this.m; ++j) {
                dx[i] = dx[i] + this.B[i][j] * ut[j];
            }
        }
        return dx;
    }

    public Double[] gxut(double tk, Double[] xt, Double[] ut) {
        Double[] yy = new Double[this.p];
        for (int i = 0; i < this.p; ++i) {
            int j;
            yy[i] = 0.0;
            for (j = 0; j < this.n; ++j) {
                yy[i] = yy[i] + this.C[i][j] * xt[j];
            }
            for (j = 0; j < this.m; ++j) {
                yy[i] = yy[i] + this.D[i][j] * ut[j];
            }
        }
        this.y = (Double[])yy.clone();
        return yy;
    }
}

