/*
 * Decompiled with CFR 0.152.
 */
package lib.atomic.dynamic.continuous;

import lib.atomic.dynamic.IDynSys;
import lib.atomic.dynamic.Integrator;
import lib.atomic.dynamic.Sizes;

public abstract class SScnlsys
implements IDynSys {
    private int n = 1;
    private int m = 1;
    private int p = 1;
    private Double[] x;
    private Double[] y;
    final double DEFAULT_H = 0.01;
    private double h = 0.01;
    private int k = 0;

    public SScnlsys() {
        this.x[0] = 0.0;
        this.y[0] = 0.0;
    }

    public Double[] getState() {
        return this.x;
    }

    public Double[] getOutput() {
        return this.y;
    }

    public int getNx() {
        return this.n;
    }

    public int getNu() {
        return this.m;
    }

    public int getNy() {
        return this.p;
    }

    public Sizes getSizes() {
        Sizes sizes = new Sizes();
        sizes.Nxc = this.n;
        sizes.Nu = this.m;
        sizes.Ny = this.p;
        return sizes;
    }

    public double getSampling() {
        return this.h;
    }

    public double getTime() {
        return (double)this.k * this.h;
    }

    public Double[] update(double dt, Double[] xt, Double[] ut) {
        Double[] xx = new Double[xt.length];
        xx = Integrator.rk4(this, (double)this.k * this.h, this.h, xt, ut, xt.length);
        this.x = (Double[])xx.clone();
        ++this.k;
        return xx;
    }

    public Double[] fxut(double dt, Double[] xt, Double[] ut) {
        Double[] dx = new Double[xt.length];
        dx = ut;
        return dx;
    }

    public Double[] gxut(double tk, Double[] xt, Double[] ut) {
        Double[] yy = new Double[this.p];
        yy = xt;
        this.y = (Double[])yy.clone();
        return yy;
    }
}

