/*
 * Decompiled with CFR 0.152.
 */
package lib.atomic.dynamic.continuous;

import lib.atomic.dynamic.IDynSys;
import lib.atomic.dynamic.Integrator;
import lib.atomic.dynamic.Sizes;

public class SScvdpol
implements IDynSys {
    double mm = 1.0;
    double cc = 0.5;
    double kk = 1.0;
    private int n = 2;
    private int m = 0;
    private int p = 1;
    private Double[] x = new Double[this.n];
    private Double[] y = new Double[this.p];
    final double DEFAULT_H = 0.01;
    private double h = 0.01;
    private int k = 0;

    public SScvdpol(Double[] x0, double h) {
        this.h = h;
        this.x = x0;
        this.y[0] = 0.0;
    }

    public Double[] getState() {
        return this.x;
    }

    public Double[] getOutput() {
        return this.y;
    }

    public int getNx() {
        return this.n;
    }

    public int getNu() {
        return this.m;
    }

    public int getNy() {
        return this.p;
    }

    public Sizes getSizes() {
        Sizes sizes = new Sizes();
        sizes.Nxc = this.n;
        sizes.Nu = this.m;
        sizes.Ny = this.p;
        return sizes;
    }

    public double getSampling() {
        return this.h;
    }

    public double getTime() {
        return (double)this.k * this.h;
    }

    public Double[] update(double dt, Double[] xt, Double[] ut) {
        Double[] xx = new Double[xt.length];
        xx = Integrator.rk4(this, (double)this.k * this.h, this.h, xt, ut, xt.length);
        this.x = (Double[])xx.clone();
        ++this.k;
        return xx;
    }

    public Double[] fxut(double dt, Double[] xt, Double[] ut) {
        Double[] dx = new Double[xt.length];
        Double u = xt[1];
        Double v = 1.0 / this.mm * (-this.kk * this.x[0] + 2.0 * this.cc * (1.0 - this.x[0] * this.x[0]) * this.x[1]);
        dx[0] = u;
        dx[1] = v;
        return dx;
    }

    public Double[] gxut(double tk, Double[] xt, Double[] ut) {
        Double[] yy = new Double[this.p];
        yy[0] = xt[0];
        this.y = (Double[])yy.clone();
        return yy;
    }
}

