/*
 * Decompiled with CFR 0.152.
 */
package lib.atomic.dynamic.discrete;

import lib.atomic.dynamic.IDynSys;
import lib.atomic.dynamic.Sizes;

public class SSdvdpol
implements IDynSys {
    double mm = 1.0;
    double cc = 0.5;
    double kk = 1.0;
    private int n = 2;
    private int m = 1;
    private int p = 1;
    private Double[] x = new Double[this.n];
    private Double[] y = new Double[this.p];
    private double h = 1.0;
    private int k = 0;

    public SSdvdpol(Double[] x0, double h) {
        this.h = h;
        this.x = x0;
        this.y[0] = 0.0;
    }

    public Double[] getState() {
        return this.x;
    }

    public Double[] getOutput() {
        return this.y;
    }

    public int getNx() {
        return this.n;
    }

    public int getNu() {
        return this.m;
    }

    public int getNy() {
        return this.p;
    }

    public Sizes getSizes() {
        Sizes sizes = new Sizes();
        sizes.Nxd = this.n;
        sizes.Nu = this.m;
        sizes.Ny = this.p;
        return sizes;
    }

    public double getSampling() {
        return this.h;
    }

    public double getTime() {
        return (double)this.k * this.h;
    }

    public Double[] update(double dt, Double[] xt, Double[] ut) {
        Double[] xx = new Double[xt.length];
        xx = this.fxut(dt, xt, ut);
        this.x = (Double[])xx.clone();
        ++this.k;
        return xx;
    }

    public Double[] fxut(double dt, Double[] xt, Double[] ut) {
        Double[] xx = new Double[xt.length];
        Double u = xt[1];
        Double v = 1.0 / this.mm * (-this.kk * xt[0] + 2.0 * this.cc * (1.0 - xt[0] * xt[0]) * xt[1]);
        xx[0] = xt[0] + dt * u;
        xx[1] = xt[1] + dt * v;
        return xx;
    }

    public Double[] gxut(double tk, Double[] xt, Double[] ut) {
        Double[] yy = new Double[]{xt[0]};
        this.y = yy;
        return yy;
    }
}

