/*
 * Decompiled with CFR 0.152.
 */
package lib.atomic.math;

import eval.eval;
import java.util.Collection;
import java.util.Iterator;
import xdevs.kernel.modeling.AtomicImpl;
import xdevs.kernel.modeling.MessageImpl;
import xdevs.kernel.modeling.api.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringFunction
extends AtomicImpl {
    public static final String xIn = "xIn";
    public static final String uIn = "uIn";
    public static final String out = "out";
    private String fExpr;
    private double[] fVector;
    private double time;

    public StringFunction(String name, double t0, Collection<String> fStrings) {
        super(name);
        super.addInport(xIn);
        super.addInport(uIn);
        super.addOutport(out);
        this.fExpr = "";
        for (String component : fStrings) {
            if (this.fExpr.length() > 0) {
                this.fExpr = this.fExpr + ";";
            }
            this.fExpr = this.fExpr + component;
        }
        this.fVector = new double[fStrings.size()];
        this.time = t0;
    }

    @Override
    public void deltint() {
        this.time += super.getSigma();
        super.setSigma(Double.POSITIVE_INFINITY);
    }

    @Override
    public void deltext(double e, Message input) {
        int i;
        this.time += e;
        double[] x = null;
        Iterator<Object> itrx = input.getValuesOnPort(xIn).iterator();
        if (itrx.hasNext()) {
            x = (double[])itrx.next();
        }
        double[] u = null;
        Iterator<Object> itru = input.getValuesOnPort(uIn).iterator();
        if (itru.hasNext()) {
            u = (double[])itru.next();
        }
        String fExprAux = this.fExpr;
        fExprAux = fExprAux.replaceAll("_t_", "" + this.time);
        String expr1 = "";
        String expr2 = "";
        if (x != null) {
            for (i = 0; i < x.length; ++i) {
                expr1 = "_x" + i + "_";
                expr2 = "" + x[i];
                fExprAux = fExprAux.replaceAll(expr1, expr2);
            }
        }
        if (u != null) {
            for (i = 0; i < u.length; ++i) {
                expr1 = "_u" + i + "_";
                expr2 = "" + u[i];
                fExprAux = fExprAux.replaceAll(expr1, expr2);
            }
        }
        String res = eval.evaluate((String)fExprAux, (boolean)true, (boolean)false);
        String[] ans = res.split("\n");
        for (int i2 = 0; i2 < ans.length; ++i2) {
            this.fVector[i2] = Double.valueOf(ans[i2]);
        }
        super.setSigma(0.0);
    }

    @Override
    public Message lambda() {
        MessageImpl msg = new MessageImpl();
        msg.add(out, this.fVector);
        return msg;
    }
}

