/*
 * Decompiled with CFR 0.152.
 */
package lib.atomic.sources;

import xdevs.kernel.modeling.AtomicImpl;
import xdevs.kernel.modeling.MessageImpl;
import xdevs.kernel.modeling.api.Message;

public class QSine
extends AtomicImpl {
    public static final String out = "out";
    private double w;
    private double fi = 0.0;
    private double A = 1.0;
    private double of = 0.0;
    protected double q = 0.01;
    protected double t = 0.0;
    protected double dt;
    protected double output;
    private int debug = 0;

    public QSine(String name, double w) {
        super(name);
        this.w = w;
        this.addOutport(out);
        super.setPhase("initial");
        super.setSigma(0.0);
        this.output = this.fun(super.getPhase());
    }

    public QSine(String name, double w, double fi) {
        this(name, w);
        this.fi = fi;
    }

    public QSine(String name, double w, double fi, double q) {
        this(name, w, fi);
        this.q = q;
    }

    public QSine(String name, double w, double fi, double A, double of) {
        this(name, w, fi);
        this.A = A;
        this.of = of;
    }

    public QSine(String name, double w, double fi, double A, double of, double q) {
        this(name, w, fi, A, of);
        this.q = q / A;
    }

    public double ta(double t) {
        return super.getSigma();
    }

    public void deltext(double e, Message x) {
    }

    public void deltint() {
        this.output = this.fun(super.getPhase());
        super.setSigma(this.dt);
        super.setPhase("active");
    }

    public Message lambda() {
        MessageImpl msg = new MessageImpl();
        double out = this.A * this.output + this.of;
        msg.add(out, out);
        return msg;
    }

    protected double fun(String phase) {
        double y = Math.sin(this.w * this.t + this.fi);
        double yc = Math.cos(this.w * this.t + this.fi);
        double yn = 0.0;
        if (phase == "initial") {
            super.setPhase("active");
            if (this.debug == 1) {
                System.out.println("t: " + this.t + "; y: " + y + "; yc: " + yc + " " + super.getPhase());
            }
            return y;
        }
        if (this.w == 0.0) {
            this.dt = Double.MAX_VALUE;
            super.setPhase("passive");
            return y;
        }
        int se = 0;
        if (yc > 0.0) {
            if (y + this.q <= 1.0) {
                yn = y + this.q;
            } else {
                yn = 2.0 - y - this.q;
                se = 1;
            }
        } else if (yc < 0.0) {
            if (y - this.q >= -1.0) {
                yn = y - this.q;
            } else {
                yn = -2.0 - y + this.q;
                se = -1;
            }
        } else {
            yn = y > 0.0 ? y - this.q : y + this.q;
        }
        if (se == 0) {
            this.dt = (Math.asin(yn) - Math.asin(y)) / this.w;
            this.dt = Math.abs(this.dt);
        } else if (se == 1) {
            double dt1 = (Math.asin(1.0) - Math.asin(y)) / this.w;
            double dt2 = (Math.asin(yn) - Math.asin(1.0)) / this.w;
            this.dt = Math.abs(dt1) + Math.abs(dt2);
        } else {
            double dt1 = (Math.asin(-1.0) - Math.asin(y)) / this.w;
            double dt2 = (Math.asin(yn) - Math.asin(-1.0)) / this.w;
            this.dt = Math.abs(dt1) + Math.abs(dt2);
        }
        if (this.debug == 1) {
            System.out.println("t: " + this.t + "; y: " + yn);
        }
        this.t += this.dt;
        return yn;
    }
}

