/*
 * Decompiled with CFR 0.152.
 */
package lib.coupled.examples;

import lib.atomic.continuous.IntegratorEulerWithReset;
import lib.atomic.general.FlowGenerator;
import lib.atomic.sinks.ScopeLine;
import lib.coupled.DevsDess;
import xdevs.kernel.modeling.CoupledImpl;
import xdevs.kernel.simulation.CoordinatorImpl;

public class BarrelFiller
extends CoupledImpl {
    public static final String in = "in";
    public static final String out = "out";

    public BarrelFiller(String name) {
        super(name);
        this.addInport(in);
        this.addOutport(out);
        FlowGenerator fl = new FlowGenerator("inflow", 0.01, 0.0, 0.5, 0.0, 2.0, 1.5);
        IntegratorEulerWithReset integr = new IntegratorEulerWithReset("Integrator", 0.01, 0.0);
        ScopeLine scope = new ScopeLine("BarrelFiller");
        DevsDess devsdess = new DevsDess("Barrel Filler", integr, "reset", 10.0);
        scope.addInport("contents");
        scope.addInport("inflow");
        this.addComponent(devsdess);
        this.addComponent(scope);
        this.addComponent(fl);
        this.addCoupling(fl, out, devsdess, in);
        this.addCoupling(fl, out, scope, "inflow");
        this.addCoupling(devsdess, out, scope, "contents");
        this.addCoupling(devsdess, "state_event", this, out);
    }

    public static void main(String[] args) {
        BarrelFiller bf = new BarrelFiller("Barrel Filler");
        CoordinatorImpl coordinator = new CoordinatorImpl(bf);
        coordinator.simulate(2000L);
    }
}

