/*
 * Decompiled with CFR 0.152.
 */
package lib.coupled.examples;

import lib.atomic.math.ClockSISampler;
import lib.atomic.sinks.ScopeStep;
import lib.atomic.sources.Clock;
import lib.atomic.sources.QRamp;
import xdevs.kernel.modeling.CoupledImpl;
import xdevs.kernel.simulation.CoordinatorImpl;

public class ViewingClockSISampler
extends CoupledImpl {
    public ViewingClockSISampler(String name) {
        super(name);
        QRamp rampa = new QRamp("rampa", 1.0, 1.0, 2.0, 0.3);
        Clock reloj = new Clock("reloj", 0.25);
        ClockSISampler sampler = new ClockSISampler("sampler");
        ScopeStep scope = new ScopeStep("scope");
        scope.addInport("in0");
        scope.addInport("in1");
        scope.addInport("in2");
        super.addComponent(rampa);
        super.addComponent(reloj);
        super.addComponent(sampler);
        super.addComponent(scope);
        super.addCoupling(rampa, "out", sampler, "signal");
        super.addCoupling(reloj, "out", sampler, "clock");
        super.addCoupling(sampler, "out", scope, "in0");
        super.addCoupling(rampa, "out", scope, "in1");
        super.addCoupling(reloj, "out", scope, "in2");
    }

    public static void main(String[] args) {
        System.out.println("Simulaci\ufffdn: ClockSISampler");
        ViewingClockSISampler model = new ViewingClockSISampler("Modelo");
        CoordinatorImpl coordinator = new CoordinatorImpl(model);
        coordinator.simulate(5.0);
    }
}

