/*
 * Decompiled with CFR 0.152.
 */
package lib.coupled.examples;

import lib.atomic.math.SingleInputSampler;
import lib.atomic.sinks.ScopeStep;
import lib.atomic.sources.Clock;
import lib.atomic.sources.QRamp;
import xdevs.kernel.modeling.CoupledImpl;
import xdevs.kernel.simulation.CoordinatorImpl;

public class ViewingSingleInputSampler
extends CoupledImpl {
    public ViewingSingleInputSampler(String name) {
        super(name);
        QRamp rampa = new QRamp("rampa", 1.0, 1.0, 2.0, 0.3);
        ScopeStep scope = new ScopeStep("scope");
        scope.addInport("in0");
        scope.addInport("in1");
        scope.addInport("in2");
        SingleInputSampler sampler = new SingleInputSampler("sampler", 0.25);
        Clock reloj = new Clock("reloj", 0.25);
        super.addComponent(rampa);
        super.addComponent(scope);
        super.addComponent(sampler);
        super.addComponent(reloj);
        super.addCoupling(rampa, "out", sampler, "in");
        super.addCoupling(sampler, "out", scope, "in0");
        super.addCoupling(rampa, "out", scope, "in1");
        super.addCoupling(reloj, "out", scope, "in2");
    }

    public static void main(String[] args) {
        System.out.println("Simulaci\ufffdn: SingleInputSampler");
        ViewingSingleInputSampler model = new ViewingSingleInputSampler("Modelo");
        CoordinatorImpl coordinator = new CoordinatorImpl(model);
        coordinator.simulate(5.0);
    }
}

