/*
 * Decompiled with CFR 0.152.
 */
package proyectoSI.barcos;

import java.util.Vector;
import proyectoSI.matematico.IFuncion;
import proyectoSI.matematico.IIntegrador;
import proyectoSI.matematico.RungeKutta;
import xdevs.kernel.modeling.AtomicStateImpl;
import xdevs.kernel.modeling.MessageImpl;
import xdevs.kernel.modeling.api.Message;

public class ModeloReferencia
extends AtomicStateImpl
implements IFuncion {
    private IIntegrador integrador = new RungeKutta();
    public static final String puertoIn = "puertoIn";
    public static final String puertoOut = "puertoOut";
    public static final int Reset = 101;
    public static final int CambioRumbo = 102;
    public static final String tactual = "tactual";
    public static final String dt = "dt";
    public static final String x1 = "x1";
    public static final String x2 = "x2";
    public static final String x3 = "x3";
    public static final String Zetar = "Zetar";
    public static final String Wr = "Wr";

    public ModeloReferencia(String name, double _Wr, double _Zr, double _dt) {
        super(name);
        this.addState(Wr);
        this.setStateValue(Wr, _Wr);
        this.addState(dt);
        this.addState(tactual);
        this.addState(Zetar);
        this.setStateValue(Zetar, _Zr);
        this.addState(x1);
        this.setStateValue(x1, 0);
        this.addState(x2);
        this.setStateValue(x2, 0);
        this.addState(x3);
        this.setStateValue(x3, 0);
        this.setStateValue(dt, _dt);
        this.addInport(puertoIn);
        this.addOutport(puertoOut);
        this.setSigma(Double.POSITIVE_INFINITY);
    }

    public void ponValor(double valor) {
        this.setStateValue(tactual, 0);
        this.setStateValue("Psid", valor);
    }

    public void deltext(double e, Message x) {
        for (Vector vector : x.getValuesOnPort(puertoIn)) {
            switch ((Integer)vector.get(0)) {
                case 101: {
                    this.ponValor((Double)vector.get(1));
                    this.setSigma(0.0);
                    break;
                }
                case 102: {
                    this.ponValor((Double)vector.get(1));
                    this.setSigma(0.0);
                }
            }
        }
    }

    public void deltint() {
        this.setSigma(5.0);
    }

    public void imprimeEstado() {
        System.out.println("tactual " + this.getStateValue(tactual).doubleValue() + "dt " + this.getStateValue(dt).doubleValue() + "x1 " + this.getStateValue(x1).doubleValue() + "x2 " + this.getStateValue(x2).doubleValue() + "x3 " + this.getStateValue(x3).doubleValue() + "Zetar " + this.getStateValue(Zetar).doubleValue() + "Psid " + this.getStateValue("Psid").doubleValue() + "Wr " + this.getStateValue(Wr).doubleValue());
    }

    public Message lambda() {
        this.avanzaTiempo();
        MessageImpl msg = new MessageImpl();
        Vector<Double> vector = new Vector<Double>(3, 0);
        double psir = this.getStateValue(x1).doubleValue();
        double rr = this.getStateValue(x2).doubleValue();
        double x1 = this.getStateValue(x1).doubleValue();
        double x2 = this.getStateValue(x2).doubleValue();
        double x3 = this.getStateValue(x3).doubleValue();
        double wr = this.getStateValue(Wr).doubleValue();
        double psid = this.getStateValue("Psid").doubleValue();
        double zr = this.getStateValue(Zetar).doubleValue();
        double alfar = -(wr * wr) * x1 - wr * zr * x2 + x3;
        vector.add(psir);
        vector.add(rr);
        vector.add(alfar);
        msg.add(puertoOut, vector);
        return msg;
    }

    public double normalizar(double angulo) {
        double angulo_normalizado = angulo;
        if (angulo > Math.PI) {
            angulo_normalizado = this.normalizar(angulo - Math.PI * 2);
        }
        if (angulo < -Math.PI) {
            angulo_normalizado = this.normalizar(angulo + Math.PI * 2);
        }
        return angulo_normalizado;
    }

    public void actualizaEstados(double[] estadosActuales) {
        this.setStateValue(x1, estadosActuales[0]);
        if (estadosActuales[1] > 1.0) {
            this.setStateValue(x2, 1);
        } else if (estadosActuales[1] < -1.0) {
            this.setStateValue(x2, -1);
        } else {
            this.setStateValue(x2, estadosActuales[1]);
        }
        this.setStateValue(x3, estadosActuales[2]);
    }

    public void avanzaTiempo() {
        this.actualizaEstados(this.integrador.integra(this, 5.0, this.getStateValue(tactual).doubleValue()));
        this.setStateValue(tactual, this.getStateValue(tactual).doubleValue() + 5.0);
    }

    public double[] dameControlActual() {
        return null;
    }

    public double[] dameDerivadas(double tiempo, double[] estados, double[] control) {
        double x1 = this.getStateValue(x1).doubleValue();
        double x2 = this.getStateValue(x2).doubleValue();
        double x3 = this.getStateValue(x3).doubleValue();
        double wr = this.getStateValue(Wr).doubleValue();
        double zr = this.getStateValue(Zetar).doubleValue();
        double psid = this.getStateValue("Psid").doubleValue();
        double[] derivadas = new double[]{x2 < -1.0 ? -1.0 : (x2 > 1.0 ? 1.0 : x2), -(wr * wr) * x1 - 2.0 * wr * zr * x2 + x3, -wr * x3 + wr * wr * wr * psid};
        return derivadas;
    }

    public double[] dameEstadoActual() {
        double[] estado = new double[]{this.getStateValue(x1).doubleValue(), this.getStateValue(x2).doubleValue(), this.getStateValue(x3).doubleValue()};
        return estado;
    }
}

