/*
 * Decompiled with CFR 0.152.
 */
package proyectoSI.genetic;

import java.util.ArrayList;
import java.util.Random;
import proyectoSI.genetic.Tupla;
import proyectoSI.incidencias.CasillaNaufrago;
import proyectoSI.incidencias.ProbabilidadNaufragoCasillas;
import proyectoSI.matematico.FuncionProbabilidadAbstracta;
import proyectoSI.simulacion.Algoritmo;
import proyectoSI.simulacion.Punto;
import proyectoSI.simulacion.Ruta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Genetic
implements Algoritmo {
    private int dimension;
    protected ArrayList<ArrayList<Integer>> trayectorias;
    private int numpoints;
    private double distancia;
    private Punto punto1;

    public Genetic(int dimension, int numpoints) {
        this.dimension = dimension;
        this.trayectorias = new ArrayList();
        this.numpoints = numpoints;
        this.distancia = 0.0;
        this.punto1 = new Punto(0.0, 0.0, 0.0);
    }

    public void randomTrayectories(ArrayList<Integer> puntosinciales) {
        Random a = new Random();
        for (int i = 0; i < puntosinciales.size(); ++i) {
            ArrayList<Integer> sol = new ArrayList<Integer>();
            ArrayList<ArrayList<Integer>> conj = new ArrayList<ArrayList<Integer>>();
            sol.add(puntosinciales.get(i));
            this.vaTray(sol, conj, 1);
            int aux = a.nextInt(conj.size());
            this.trayectorias.add(conj.get(aux));
            int aux1 = a.nextInt(conj.size());
            while (aux == aux1) {
                aux1 = a.nextInt(conj.size());
            }
            this.trayectorias.add(conj.get(aux1));
        }
    }

    public void randomTrayectoriesAlt(ArrayList<Integer> puntosinciales) {
        for (int i = 0; i < puntosinciales.size(); ++i) {
            Random a = new Random();
            ArrayList<Integer> sol = new ArrayList<Integer>();
            ArrayList<Integer> sol1 = new ArrayList<Integer>();
            sol.add(puntosinciales.get(i));
            sol1.add(puntosinciales.get(i));
            for (int j = 1; j < this.numpoints; ++j) {
                ArrayList<Integer> sigvalido1;
                ArrayList<Integer> sigvalido = this.sigvalido(sol);
                if (sigvalido.size() >= 1) {
                    sol.add(sigvalido.get(a.nextInt(sigvalido.size())));
                }
                if ((sigvalido1 = this.sigvalido(sol1)).size() < 1) continue;
                sol1.add(sigvalido1.get(a.nextInt(sigvalido1.size())));
            }
            this.trayectorias.add(sol);
            this.trayectorias.add(sol1);
        }
    }

    private ArrayList<Integer> sigvalido(ArrayList<Integer> sol) {
        ArrayList<Integer> lista = new ArrayList<Integer>();
        int casillaact = sol.get(0);
        lista.add(casillaact);
        for (int i = 1; i < sol.size(); ++i) {
            switch (sol.get(i)) {
                case 1: {
                    casillaact -= this.dimension;
                    break;
                }
                case 2: {
                    casillaact = casillaact - this.dimension + 1;
                    break;
                }
                case 3: {
                    ++casillaact;
                    break;
                }
                case 4: {
                    casillaact = casillaact + this.dimension + 1;
                    break;
                }
                case 5: {
                    casillaact += this.dimension;
                    break;
                }
                case 6: {
                    casillaact = casillaact + this.dimension - 1;
                    break;
                }
                case 7: {
                    --casillaact;
                    break;
                }
                case 8: {
                    casillaact = casillaact - this.dimension - 1;
                    break;
                }
            }
            lista.add(casillaact);
        }
        ArrayList<Integer> posibles = new ArrayList<Integer>();
        for (int i = 1; i < 9; ++i) {
            boolean aux = true;
            int dir = i;
            if (casillaact == 1 && dir != 3 && dir != 4 && dir != 5) {
                aux = false;
            }
            if (casillaact == this.dimension && dir != 7 && dir != 6 && dir != 5) {
                aux = false;
            }
            if (casillaact == this.dimension * this.dimension - this.dimension + 1 && dir != 1 && dir != 2 && dir != 3) {
                aux = false;
            }
            if (casillaact == this.dimension * this.dimension && dir != 1 && dir != 8 && dir != 7) {
                aux = false;
            }
            if (casillaact > 1 && casillaact < this.dimension && dir != 6 && dir != 5 && dir != 4 && dir != 3 && dir != 7) {
                aux = false;
            }
            if (casillaact > this.dimension * this.dimension - this.dimension + 1 && casillaact < this.dimension * this.dimension && dir != 8 && dir != 1 && dir != 2 && dir != 7 && dir != 3) {
                aux = false;
            }
            if (casillaact % this.dimension == 1 && casillaact != 1 && casillaact != this.dimension * this.dimension - this.dimension + 1 && dir != 1 && dir != 2 && dir != 3 && dir != 4 && dir != 5) {
                aux = false;
            }
            if (casillaact % this.dimension == 0 && casillaact != this.dimension && casillaact != this.dimension * this.dimension && dir != 5 && dir != 6 && dir != 7 && dir != 8 && dir != 1) {
                aux = false;
            }
            if (!aux) continue;
            posibles.add(dir);
        }
        ArrayList<Integer> mejores = new ArrayList<Integer>();
        for (int i = 0; i < posibles.size(); ++i) {
            int casillaaux = casillaact;
            switch ((Integer)posibles.get(i)) {
                case 1: {
                    casillaaux -= this.dimension;
                    break;
                }
                case 2: {
                    casillaaux = casillaaux - this.dimension + 1;
                    break;
                }
                case 3: {
                    ++casillaaux;
                    break;
                }
                case 4: {
                    casillaaux = casillaaux + this.dimension + 1;
                    break;
                }
                case 5: {
                    casillaaux += this.dimension;
                    break;
                }
                case 6: {
                    casillaaux = casillaaux + this.dimension - 1;
                    break;
                }
                case 7: {
                    --casillaaux;
                    break;
                }
                case 8: {
                    casillaaux = casillaaux - this.dimension - 1;
                    break;
                }
            }
            if (lista.contains(casillaaux)) continue;
            mejores.add(posibles.get(i));
        }
        if (mejores.size() > 0) {
            return mejores;
        }
        return posibles;
    }

    public void crossover(ArrayList<Integer> arrayList, ArrayList<Integer> arrayList2, ArrayList<Integer> infoOrden) {
        if (arrayList.size() > 1) {
            int i;
            boolean valido = false;
            ArrayList<Integer> hijo1 = new ArrayList<Integer>(arrayList.size());
            ArrayList<Integer> hijo2 = new ArrayList<Integer>(arrayList.size());
            for (i = 0; !valido && i < 1000; ++i) {
                hijo1.clear();
                hijo2.clear();
                int aux = new Random().nextInt(arrayList.size() - 1);
                ++aux;
                for (int j = 0; j < arrayList.size(); ++j) {
                    if (j < aux) {
                        hijo1.add(arrayList.get(j));
                        hijo2.add(arrayList2.get(j));
                        continue;
                    }
                    hijo1.add(arrayList2.get(j));
                    hijo2.add(arrayList.get(j));
                }
                valido = this.validarRuta(hijo1) && this.validarRuta(hijo2);
            }
            if (i < 1000) {
                ArrayList<Double> valores = new ArrayList<Double>();
                double min1 = 2.147483647E9;
                double min2 = 2.147483647E9;
                int pos1 = 0;
                int pos2 = 0;
                for (int d = 0; d < this.trayectorias.size(); ++d) {
                    valores.add(this.valor(this.trayectorias.get(d), infoOrden));
                    if (this.valor(this.trayectorias.get(d), infoOrden) <= min1) {
                        min2 = min1;
                        pos2 = pos1;
                        min1 = this.valor(this.trayectorias.get(d), infoOrden);
                        pos1 = d;
                        continue;
                    }
                    if (!(this.valor(this.trayectorias.get(d), infoOrden) < min2)) continue;
                    min2 = this.valor(this.trayectorias.get(d), infoOrden);
                    pos2 = d;
                }
                double valor1 = this.valor(hijo1, infoOrden);
                double valor2 = this.valor(hijo2, infoOrden);
                if (valor1 > min1) {
                    this.trayectorias.set(pos1, hijo1);
                    if (valor2 > min2) {
                        this.trayectorias.set(pos2, hijo2);
                    } else if (valor2 > valor1) {
                        this.trayectorias.set(pos1, hijo2);
                    }
                } else if (valor2 > min1) {
                    this.trayectorias.set(pos1, hijo2);
                }
            }
        }
    }

    private boolean validarRuta(ArrayList<Integer> ruta) {
        int casillaact = ruta.get(0);
        boolean valido = true;
        int dir = ruta.get(1);
        if (casillaact == 1 && dir != 3 && dir != 4 && dir != 5) {
            valido = false;
        }
        if (casillaact == this.dimension && dir != 7 && dir != 6 && dir != 5) {
            valido = false;
        }
        if (casillaact == this.dimension * this.dimension - this.dimension + 1 && dir != 1 && dir != 2 && dir != 3) {
            valido = false;
        }
        if (casillaact == this.dimension * this.dimension && dir != 1 && dir != 8 && dir != 7) {
            valido = false;
        }
        if (casillaact > 1 && casillaact < this.dimension && dir != 6 && dir != 5 && dir != 4 && dir != 3 && dir != 7) {
            valido = false;
        }
        if (casillaact > this.dimension * this.dimension - this.dimension + 1 && casillaact < this.dimension * this.dimension && dir != 8 && dir != 1 && dir != 2 && dir != 7 && dir != 3) {
            valido = false;
        }
        if (casillaact < this.dimension * this.dimension - this.dimension + 1 && casillaact > 1 && this.borde(casillaact, 1, this.dimension * this.dimension - this.dimension + 1) && dir != 1 && dir != 2 && dir != 3 && dir != 4 && dir != 5) {
            valido = false;
        }
        if (casillaact < this.dimension * this.dimension && casillaact > 1 && this.borde(casillaact, 4, this.dimension * this.dimension) && dir != 5 && dir != 6 && dir != 7 && dir != 8 && dir != 1) {
            valido = false;
        }
        for (int i = 1; i < ruta.size() - 1 && valido; ++i) {
            switch (ruta.get(i)) {
                case 1: {
                    casillaact -= this.dimension;
                    break;
                }
                case 2: {
                    casillaact = casillaact - this.dimension + 1;
                    break;
                }
                case 3: {
                    ++casillaact;
                    break;
                }
                case 4: {
                    casillaact = casillaact + this.dimension + 1;
                    break;
                }
                case 5: {
                    casillaact += this.dimension;
                    break;
                }
                case 6: {
                    casillaact = casillaact + this.dimension - 1;
                    break;
                }
                case 7: {
                    --casillaact;
                    break;
                }
                case 8: {
                    casillaact = casillaact - this.dimension - 1;
                    break;
                }
            }
            dir = ruta.get(i + 1);
            if (casillaact == 1 && dir != 3 && dir != 4 && dir != 5) {
                valido = false;
            }
            if (casillaact == this.dimension && dir != 7 && dir != 6 && dir != 5) {
                valido = false;
            }
            if (casillaact == this.dimension * this.dimension - this.dimension + 1 && dir != 1 && dir != 2 && dir != 3) {
                valido = false;
            }
            if (casillaact == this.dimension * this.dimension && dir != 1 && dir != 8 && dir != 7) {
                valido = false;
            }
            if (casillaact > 1 && casillaact < this.dimension && dir != 6 && dir != 5 && dir != 4 && dir != 3 && dir != 7) {
                valido = false;
            }
            if (casillaact > this.dimension * this.dimension - this.dimension + 1 && casillaact < this.dimension * this.dimension && dir != 8 && dir != 1 && dir != 2 && dir != 7 && dir != 3) {
                valido = false;
            }
            if (casillaact < this.dimension * this.dimension - this.dimension + 1 && casillaact > 1 && this.borde(casillaact, 1, this.dimension * this.dimension - this.dimension + 1) && dir != 1 && dir != 2 && dir != 3 && dir != 4 && dir != 5) {
                valido = false;
            }
            if (casillaact >= this.dimension * this.dimension || casillaact <= 1 || !this.borde(casillaact, 4, this.dimension * this.dimension) || dir == 5 || dir == 6 || dir == 7 || dir == 8 || dir == 1) continue;
            valido = false;
        }
        return valido;
    }

    public void mutation() {
    }

    public void selection() {
    }

    public void vaTray(ArrayList<Integer> sol, ArrayList<ArrayList<Integer>> conj, int k) {
        for (int i = 1; i <= 8; ++i) {
            sol.add(i);
            if (this.valido(sol) && this.norepite(sol)) {
                if (k == this.numpoints - 1) {
                    ArrayList<Integer> aux = new ArrayList<Integer>();
                    for (int j = 0; j < sol.size(); ++j) {
                        aux.add(sol.get(j));
                    }
                    conj.add(aux);
                } else {
                    this.vaTray(sol, conj, k + 1);
                }
            }
            sol.remove(sol.size() - 1);
        }
    }

    private boolean norepite(ArrayList<Integer> sol) {
        boolean aux = true;
        ArrayList<Integer> lista = new ArrayList<Integer>();
        int casillaact = sol.get(0);
        lista.add(casillaact);
        for (int i = 1; i < sol.size() - 1 && aux; ++i) {
            switch (sol.get(i)) {
                case 1: {
                    casillaact -= this.dimension;
                    break;
                }
                case 2: {
                    casillaact = casillaact - this.dimension + 1;
                    break;
                }
                case 3: {
                    ++casillaact;
                    break;
                }
                case 4: {
                    casillaact = casillaact + this.dimension + 1;
                    break;
                }
                case 5: {
                    casillaact += this.dimension;
                    break;
                }
                case 6: {
                    casillaact = casillaact + this.dimension - 1;
                    break;
                }
                case 7: {
                    --casillaact;
                    break;
                }
                case 8: {
                    casillaact = casillaact - this.dimension - 1;
                    break;
                }
            }
            if (lista.contains(casillaact)) {
                aux = false;
                continue;
            }
            lista.add(casillaact);
        }
        return aux;
    }

    private boolean valido(ArrayList<Integer> sol) {
        int casillaact = sol.get(0);
        block10: for (int i = 1; i <= sol.size() - 2; ++i) {
            switch (sol.get(i)) {
                case 1: {
                    casillaact -= this.dimension;
                    continue block10;
                }
                case 2: {
                    casillaact = casillaact - this.dimension + 1;
                    continue block10;
                }
                case 3: {
                    ++casillaact;
                    continue block10;
                }
                case 4: {
                    casillaact = casillaact + this.dimension + 1;
                    continue block10;
                }
                case 5: {
                    casillaact += this.dimension;
                    continue block10;
                }
                case 6: {
                    casillaact = casillaact + this.dimension - 1;
                    continue block10;
                }
                case 7: {
                    --casillaact;
                    continue block10;
                }
                case 8: {
                    casillaact = casillaact - this.dimension - 1;
                    continue block10;
                }
            }
        }
        boolean aux = true;
        int dir = sol.get(sol.size() - 1);
        if (casillaact == 1 && dir != 3 && dir != 4 && dir != 5) {
            aux = false;
        }
        if (casillaact == this.dimension && dir != 7 && dir != 6 && dir != 5) {
            aux = false;
        }
        if (casillaact == this.dimension * this.dimension - this.dimension + 1 && dir != 1 && dir != 2 && dir != 3) {
            aux = false;
        }
        if (casillaact == this.dimension * this.dimension && dir != 1 && dir != 8 && dir != 7) {
            aux = false;
        }
        if (casillaact > 1 && casillaact < this.dimension && dir != 6 && dir != 5 && dir != 4 && dir != 3 && dir != 7) {
            aux = false;
        }
        if (casillaact > this.dimension * this.dimension - this.dimension + 1 && casillaact < this.dimension * this.dimension && dir != 8 && dir != 1 && dir != 2 && dir != 7 && dir != 3) {
            aux = false;
        }
        if (casillaact < this.dimension * this.dimension - this.dimension + 1 && casillaact > 1 && this.borde(casillaact, 1, this.dimension * this.dimension - this.dimension + 1) && dir != 1 && dir != 2 && dir != 3 && dir != 4 && dir != 5) {
            aux = false;
        }
        if (casillaact < this.dimension * this.dimension && casillaact > 1 && this.borde(casillaact, 4, this.dimension * this.dimension) && dir != 5 && dir != 6 && dir != 7 && dir != 8 && dir != 1) {
            aux = false;
        }
        return aux;
    }

    private boolean borde(int casillaact, int i, int lim) {
        boolean aux = false;
        int auxint = i;
        while (auxint < lim) {
            if (casillaact != (auxint += this.dimension)) continue;
            aux = true;
        }
        return aux;
    }

    public ArrayList<Integer> contruccionEspacio(ArrayList<CasillaNaufrago> nauf, Punto avion, Punto punto_inicial, FuncionProbabilidadAbstracta probabilidadAngulo, FuncionProbabilidadAbstracta probabilidadVelocidad, int tiempo) {
        int i;
        double norte = this.masNorte(nauf);
        double sur = this.masSur(nauf);
        double este = this.masEste(nauf);
        double oeste = this.masOeste(nauf);
        this.distancia = nauf.get(0).get_varE();
        this.punto1.setE(oeste);
        this.punto1.setN(norte - this.distancia);
        int lon = 0;
        double auxN = norte;
        while (auxN > sur) {
            auxN -= this.distancia;
            ++lon;
        }
        int lon1 = 0;
        double auxO = oeste;
        while (auxO < este) {
            auxO += this.distancia;
            ++lon1;
        }
        int lonfin = lon > lon1 ? lon : lon1;
        this.dimension = lonfin;
        int[][] info = new int[this.dimension][this.dimension];
        for (int i2 = 0; i2 < this.dimension; ++i2) {
            for (int j = 0; j < this.dimension; ++j) {
                boolean encontrado = false;
                for (int j2 = 0; j2 < nauf.size() && !encontrado; ++j2) {
                    if (nauf.get(j2).pertenece(norte - (double)i2 * this.distancia - this.distancia, oeste + (double)j * this.distancia) == -1) continue;
                    info[i2][j] = nauf.get(j2).pertenece(norte - (double)i2 * this.distancia - this.distancia, oeste + (double)j * this.distancia);
                    encontrado = true;
                }
            }
        }
        ArrayList<Integer> infoOrden = new ArrayList<Integer>();
        for (i = 0; i < this.dimension; ++i) {
            for (int j = 0; j < this.dimension; ++j) {
                int naufragos = info[i][j];
                infoOrden.add(naufragos);
            }
        }
        for (i = 0; i < infoOrden.size(); ++i) {
            Punto aux = new Punto(this.punto1.getN() + this.distancia / 2.0 - (double)(i / this.dimension) * this.distancia, this.punto1.getE() + this.distancia / 2.0 + this.distancia * (double)(i % this.dimension), 0.0);
            infoOrden.set(i, (int)((double)((Integer)infoOrden.get(i)).intValue() + (double)((Integer)infoOrden.get(i)).intValue() * Genetic.valoracion(aux, punto_inicial, probabilidadAngulo, probabilidadVelocidad, tiempo)));
        }
        ArrayList<Integer> puntosinciales = new ArrayList<Integer>();
        if (avion.getE() <= auxO && avion.getE() >= oeste && avion.getN() <= norte && avion.getN() >= auxN) {
            int i3 = 0;
            int j = 0;
            for (double calcN = norte - nauf.get(0).get_varN(); avion.getN() < calcN; calcN -= nauf.get(0).get_varN()) {
                ++i3;
            }
            for (double calcE = oeste; avion.getE() > calcE; calcE += nauf.get(0).get_varE()) {
                ++j;
            }
            int casilla = 1;
            casilla = casilla + i3 * this.dimension + j;
            puntosinciales = this.adyacentes(casilla);
        } else {
            int i4;
            ArrayList<Tupla> tupla = new ArrayList<Tupla>();
            for (i4 = 1; i4 <= this.dimension; ++i4) {
                tupla.add(new Tupla(this.distancia(avion.getE(), avion.getN(), norte - nauf.get(0).get_varN(), oeste + (double)(i4 - 1) * nauf.get(0).get_varE()), i4));
                tupla.add(new Tupla(this.distancia(avion.getE(), avion.getN(), norte - (double)this.dimension * nauf.get(0).get_varN(), oeste + (double)(i4 - 1) * nauf.get(0).get_varE()), this.dimension * this.dimension - this.dimension + 1));
                tupla.add(new Tupla(this.distancia(avion.getE(), avion.getN(), norte - (double)i4 * nauf.get(0).get_varN(), oeste), this.dimension * (i4 - 1) + 1));
                tupla.add(new Tupla(this.distancia(avion.getE(), avion.getN(), norte - (double)i4 * nauf.get(0).get_varN(), oeste + (double)(this.dimension - 1) * nauf.get(0).get_varE()), i4 * this.dimension));
            }
            while (tupla.size() > this.dimension * 2) {
                int pos = 0;
                double valor = ((Tupla)tupla.get(0)).getDistancia();
                for (int i5 = 1; i5 < tupla.size(); ++i5) {
                    if (!(((Tupla)tupla.get(i5)).getDistancia() > valor)) continue;
                    valor = ((Tupla)tupla.get(i5)).getDistancia();
                    pos = i5;
                }
                tupla.remove(pos);
            }
            for (i4 = 0; i4 < tupla.size(); ++i4) {
                puntosinciales.add(((Tupla)tupla.get(i4)).getCasilla());
            }
        }
        this.randomTrayectoriesAlt(puntosinciales);
        for (int j = 0; j < 100; ++j) {
            ArrayList<Double> valores = new ArrayList<Double>();
            double sumvalores = 0.0;
            for (int i6 = 0; i6 < this.trayectorias.size(); ++i6) {
                valores.add(this.valor(this.trayectorias.get(i6), infoOrden));
                sumvalores += ((Double)valores.get(i6)).doubleValue();
            }
            ArrayList<Double> rango = new ArrayList<Double>();
            double cuenta = 0.0;
            for (int i7 = 0; i7 < valores.size(); ++i7) {
                rango.add(cuenta + (Double)valores.get(i7) * 360.0 / sumvalores);
                cuenta += (Double)valores.get(i7) * 360.0 / sumvalores;
            }
            int num1 = new Random().nextInt(360);
            int num2 = new Random().nextInt(360);
            int aux1 = -1;
            int aux2 = -1;
            for (int i8 = 0; i8 < rango.size(); ++i8) {
                if ((double)num1 < (Double)rango.get(i8) && aux1 == -1) {
                    aux1 = i8;
                }
                if (!((double)num2 < (Double)rango.get(i8)) || aux2 != -1) continue;
                aux2 = i8;
            }
            for (int abc = 0; aux1 == aux2 && abc < 1000; ++abc) {
                num2 = new Random().nextInt(360);
                aux2 = -1;
                for (int i9 = 0; i9 < rango.size(); ++i9) {
                    if (!((double)num2 < (Double)rango.get(i9)) || aux2 != -1) continue;
                    aux2 = i9;
                }
            }
            if (aux1 == -1 || aux2 == -1) continue;
            this.crossover(this.trayectorias.get(aux1), this.trayectorias.get(aux2), infoOrden);
        }
        ArrayList<Double> valores = new ArrayList<Double>();
        double max = 0.0;
        int posmax = 0;
        for (int i10 = 0; i10 < this.trayectorias.size(); ++i10) {
            valores.add(this.valor(this.trayectorias.get(i10), infoOrden));
            if (!(this.valor(this.trayectorias.get(i10), infoOrden) > max)) continue;
            max = this.valor(this.trayectorias.get(i10), infoOrden);
            posmax = i10;
        }
        return this.trayectorias.get(posmax);
    }

    private double distancia(double este1, double norte, double norte2, double este2) {
        return Math.sqrt((este1 - este2) * (este1 - este2) + (norte - norte2) * (norte - norte2));
    }

    private ArrayList<Integer> adyacentes(int casilla) {
        ArrayList<Integer> aux = new ArrayList<Integer>();
        if (casilla - this.dimension > 0) {
            aux.add(casilla - this.dimension);
        }
        if (casilla % this.dimension != 0 && casilla - this.dimension + 1 > 0) {
            aux.add(casilla - this.dimension + 1);
        }
        if (casilla % this.dimension != 0) {
            aux.add(casilla + 1);
        }
        if (casilla % this.dimension != 0 && casilla + this.dimension + 1 <= this.dimension * this.dimension) {
            aux.add(casilla + this.dimension + 1);
        }
        if (casilla + this.dimension <= this.dimension * this.dimension) {
            aux.add(casilla + this.dimension);
        }
        if (casilla % this.dimension != 1 && casilla + this.dimension - 1 <= this.dimension * this.dimension) {
            aux.add(casilla + this.dimension - 1);
        }
        if (casilla % this.dimension != 1) {
            aux.add(casilla - 1);
        }
        if (casilla % this.dimension != 1 && casilla - this.dimension - 1 > 0) {
            aux.add(casilla - this.dimension - 1);
        }
        return aux;
    }

    private double masNorte(ArrayList<CasillaNaufrago> nauf) {
        double aux = 0.0;
        for (int i = 0; i < nauf.size(); ++i) {
            if (!(nauf.get(i).get_nmin() + nauf.get(i).get_varN() > aux)) continue;
            aux = nauf.get(i).get_nmin() + nauf.get(i).get_varN();
        }
        return aux;
    }

    private double masSur(ArrayList<CasillaNaufrago> nauf) {
        double aux = Double.MAX_VALUE;
        for (int i = 0; i < nauf.size(); ++i) {
            if (!(nauf.get(i).get_nmin() < aux)) continue;
            aux = nauf.get(i).get_nmin();
        }
        return aux;
    }

    private double masEste(ArrayList<CasillaNaufrago> nauf) {
        double aux = 0.0;
        for (int i = 0; i < nauf.size(); ++i) {
            if (!(nauf.get(i).get_emin() + nauf.get(i).get_varE() > aux)) continue;
            aux = nauf.get(i).get_emin() + nauf.get(i).get_varE();
        }
        return aux;
    }

    private double masOeste(ArrayList<CasillaNaufrago> nauf) {
        double aux = Double.MAX_VALUE;
        for (int i = 0; i < nauf.size(); ++i) {
            if (!(nauf.get(i).get_emin() < aux)) continue;
            aux = nauf.get(i).get_emin();
        }
        return aux;
    }

    private ArrayList<ArrayList<Integer>> padres(ArrayList<Integer> infoOrden) {
        ArrayList<ArrayList<Integer>> padres = new ArrayList<ArrayList<Integer>>(2);
        ArrayList<Double> valores = new ArrayList<Double>();
        for (int i = 0; i < valores.size(); ++i) {
            valores.add(this.valor(this.trayectorias.get(i), infoOrden));
        }
        return padres;
    }

    private double valor(ArrayList<Integer> tray, ArrayList<Integer> infoOrden) {
        ArrayList<Integer> visitados = new ArrayList<Integer>();
        double valor = 0.0;
        int casillaact = tray.get(0);
        valor += (double)infoOrden.get(casillaact - 1).intValue();
        visitados.add(tray.get(0));
        for (int i = 1; i <= tray.size() - 2; ++i) {
            switch (tray.get(i)) {
                case 1: {
                    casillaact -= this.dimension;
                    break;
                }
                case 2: {
                    casillaact = casillaact - this.dimension + 1;
                    break;
                }
                case 3: {
                    ++casillaact;
                    break;
                }
                case 4: {
                    casillaact = casillaact + this.dimension + 1;
                    break;
                }
                case 5: {
                    casillaact += this.dimension;
                    break;
                }
                case 6: {
                    casillaact = casillaact + this.dimension - 1;
                    break;
                }
                case 7: {
                    --casillaact;
                    break;
                }
                case 8: {
                    casillaact = casillaact - this.dimension - 1;
                    break;
                }
            }
            if (visitados.contains(casillaact)) continue;
            valor += (double)infoOrden.get(casillaact - 1).intValue();
            visitados.add(casillaact);
        }
        return valor;
    }

    public Ruta dameRuta(ArrayList<CasillaNaufrago> nauf, Punto avion) {
        Ruta route = new Ruta();
        this.trayectorias.clear();
        ArrayList<Integer> ruta = this.contruccionEspacio(nauf, avion, null, null, null, 0);
        Punto aux = new Punto(this.punto1.getN() + this.distancia / 2.0 - (double)((ruta.get(0) - 1) / this.dimension) * this.distancia, this.punto1.getE() + (double)((ruta.get(0) - 1) % this.dimension) * this.distancia + this.distancia / 2.0, 0.0);
        route.a\u00f1adePunto(aux);
        Punto aux1 = new Punto(this.punto1.getN() + this.distancia / 2.0 - (double)((ruta.get(0) - 1) / this.dimension) * this.distancia, this.punto1.getE() + (double)((ruta.get(0) - 1) % this.dimension) * this.distancia + this.distancia / 2.0, 0.0);
        for (int i = 1; i < ruta.size(); ++i) {
            Punto a = new Punto(0.0, 0.0, 0.0);
            switch (ruta.get(i)) {
                case 1: {
                    a.setE(aux1.getE());
                    a.setN(aux1.getN() + this.distancia);
                    aux1.setN(aux1.getN() + this.distancia);
                    break;
                }
                case 2: {
                    a.setE(aux1.getE() + this.distancia);
                    a.setN(aux1.getN() + this.distancia);
                    aux1.setE(aux1.getE() + this.distancia);
                    aux1.setN(aux1.getN() + this.distancia);
                    break;
                }
                case 3: {
                    a.setE(aux1.getE() + this.distancia);
                    a.setN(aux1.getN());
                    aux1.setE(aux1.getE() + this.distancia);
                    aux1.setN(aux1.getN());
                    break;
                }
                case 4: {
                    a.setE(aux1.getE() + this.distancia);
                    a.setN(aux1.getN() - this.distancia);
                    aux1.setE(aux1.getE() + this.distancia);
                    aux1.setN(aux1.getN() - this.distancia);
                    break;
                }
                case 5: {
                    a.setE(aux1.getE());
                    a.setN(aux1.getN() - this.distancia);
                    aux1.setE(aux1.getE());
                    aux1.setN(aux1.getN() - this.distancia);
                    break;
                }
                case 6: {
                    a.setE(aux1.getE() - this.distancia);
                    a.setN(aux1.getN() - this.distancia);
                    aux1.setE(aux1.getE() - this.distancia);
                    aux1.setN(aux1.getN() - this.distancia);
                    break;
                }
                case 7: {
                    a.setE(aux1.getE() - this.distancia);
                    a.setN(aux1.getN());
                    aux1.setE(aux1.getE() - this.distancia);
                    aux1.setN(aux1.getN());
                    break;
                }
                case 8: {
                    a.setE(aux1.getE() - this.distancia);
                    a.setN(aux1.getN() + this.distancia);
                    aux1.setE(aux1.getE() - this.distancia);
                    aux1.setN(aux1.getN() + this.distancia);
                    break;
                }
            }
            route.a\u00f1adePunto(a);
        }
        return route;
    }

    @Override
    public Ruta dameRuta(int tipoVehiculo, Punto posicion_actual, Punto punto_inicial, int tiempo, FuncionProbabilidadAbstracta probabilidadAngulo, FuncionProbabilidadAbstracta probabilidadVelocidad, ProbabilidadNaufragoCasillas probabilidad) {
        Ruta route = new Ruta();
        this.trayectorias.clear();
        ArrayList<Integer> ruta = this.contruccionEspacio(probabilidad.dameTablero().get(probabilidad.normalizar(tiempo)), posicion_actual, punto_inicial, probabilidadAngulo, probabilidadVelocidad, tiempo);
        Punto aux = new Punto(this.punto1.getN() + this.distancia / 2.0 - (double)((ruta.get(0) - 1) / this.dimension) * this.distancia, this.punto1.getE() + (double)((ruta.get(0) - 1) % this.dimension) * this.distancia + this.distancia / 2.0, 0.0);
        route.a\u00f1adePunto(aux);
        Punto aux1 = new Punto(this.punto1.getN() + this.distancia / 2.0 - (double)((ruta.get(0) - 1) / this.dimension) * this.distancia, this.punto1.getE() + (double)((ruta.get(0) - 1) % this.dimension) * this.distancia + this.distancia / 2.0, 0.0);
        for (int i = 1; i < ruta.size(); ++i) {
            Punto a = new Punto(0.0, 0.0, 0.0);
            switch (ruta.get(i)) {
                case 1: {
                    a.setE(aux1.getE());
                    a.setN(aux1.getN() + this.distancia);
                    aux1.setN(aux1.getN() + this.distancia);
                    break;
                }
                case 2: {
                    a.setE(aux1.getE() + this.distancia);
                    a.setN(aux1.getN() + this.distancia);
                    aux1.setE(aux1.getE() + this.distancia);
                    aux1.setN(aux1.getN() + this.distancia);
                    break;
                }
                case 3: {
                    a.setE(aux1.getE() + this.distancia);
                    a.setN(aux1.getN());
                    aux1.setE(aux1.getE() + this.distancia);
                    aux1.setN(aux1.getN());
                    break;
                }
                case 4: {
                    a.setE(aux1.getE() + this.distancia);
                    a.setN(aux1.getN() - this.distancia);
                    aux1.setE(aux1.getE() + this.distancia);
                    aux1.setN(aux1.getN() - this.distancia);
                    break;
                }
                case 5: {
                    a.setE(aux1.getE());
                    a.setN(aux1.getN() - this.distancia);
                    aux1.setE(aux1.getE());
                    aux1.setN(aux1.getN() - this.distancia);
                    break;
                }
                case 6: {
                    a.setE(aux1.getE() - this.distancia);
                    a.setN(aux1.getN() - this.distancia);
                    aux1.setE(aux1.getE() - this.distancia);
                    aux1.setN(aux1.getN() - this.distancia);
                    break;
                }
                case 7: {
                    a.setE(aux1.getE() - this.distancia);
                    a.setN(aux1.getN());
                    aux1.setE(aux1.getE() - this.distancia);
                    aux1.setN(aux1.getN());
                    break;
                }
                case 8: {
                    a.setE(aux1.getE() - this.distancia);
                    a.setN(aux1.getN() + this.distancia);
                    aux1.setE(aux1.getE() - this.distancia);
                    aux1.setN(aux1.getN() + this.distancia);
                    break;
                }
            }
            route.a\u00f1adePunto(a);
        }
        route.setBucle(false);
        return route;
    }

    public static double valoracion(Punto punto, Punto puntoInicial, FuncionProbabilidadAbstracta probabilidadAngulo, FuncionProbabilidadAbstracta probabilidadVelocidad, int tiempo) {
        double angulo = Math.atan2(puntoInicial.getN() - punto.getN(), puntoInicial.getE() - punto.getE());
        double distancia = Genetic.distancia(puntoInicial, punto);
        double probabilidadA = probabilidadAngulo.evalua(angulo);
        double probabilidadV = probabilidadVelocidad.evalua(distancia / (double)tiempo);
        return probabilidadA * probabilidadV;
    }

    public static double distancia(Punto p1, Punto p2) {
        double de = Math.pow(p1.getE() - p2.getE(), 2.0);
        double dn = Math.pow(p1.getN() - p2.getN(), 2.0);
        return Math.sqrt(dn + de);
    }
}

