/*
 * Decompiled with CFR 0.152.
 */
package proyectoSI.grafico;

import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import proyectoSI.grafico.estructura.Camara;
import proyectoSI.grafico.estructura.terreno.Terreno;
import proyectoSI.modelo.CoupledSimulacion;

public class Dibujante {
    private Terreno _terreno;
    private boolean _inicializado;
    private Camara _camara;
    public static final float escalado = 100.0f;
    private CoupledSimulacion _simulacion;

    public Dibujante(Terreno terreno, CoupledSimulacion simulacion, Camara camara) {
        this._terreno = terreno;
        this._simulacion = simulacion;
        this._inicializado = false;
        this._camara = camara;
    }

    public void dibujar3D(GLAutoDrawable drawable) {
        GL gl = drawable.getGL();
        gl.glPolygonMode(1032, 6914);
        this._camara.actualizar(gl);
        this._terreno.dibujar3D(gl);
        this._simulacion.dibujar3D(gl);
    }

    public void inicializar(GL gl) {
        if (!this._inicializado) {
            this._terreno.getTafin().escalar(100.0f, 1.0f, 100.0f, gl);
            this._inicializado = true;
            this._simulacion.inicializar(gl);
        }
    }

    public void dibujar2D(GLAutoDrawable drawable, float ancho, float alto, float xLeft, float xRight, float yBot, float yTop) {
        GL gl = drawable.getGL();
        gl.glPointSize(1.0f);
        this._simulacion.dibujar2D(gl);
        this._camara.dibujar2d(gl);
    }

    public void repintarTerreno(GLAutoDrawable drawable, float ancho, float alto, float xLeft, float xRight, float yBot, float yTop) {
        GL gl = drawable.getGL();
        gl.glPointSize(1.0f);
        gl.glClear(16384);
        this._terreno.dibujar2D(gl, ancho, alto, xLeft, xRight, yBot, yTop);
    }
}

