/*
 * Decompiled with CFR 0.152.
 */
package proyectoSI.grafico;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import proyectoSI.grafico.Dibujante;
import proyectoSI.grafico.ManagerGL2D;
import proyectoSI.grafico.ManagerGL3D;
import proyectoSI.grafico.Seguible;
import proyectoSI.grafico.Ventana2D;
import proyectoSI.grafico.Ventana3D;
import proyectoSI.grafico.estructura.Camara;
import proyectoSI.grafico.estructura.PV3D;
import proyectoSI.grafico.estructura.terreno.Terreno;
import proyectoSI.modelo.ControladorAplicacion;
import proyectoSI.modelo.CoupledSimulacion;
import xdevs.kernel.modeling.AtomicStateImpl;
import xdevs.kernel.modeling.MessageImpl;
import xdevs.kernel.modeling.api.Message;

public class ManagerVista
extends AtomicStateImpl {
    public static final String InAnimacion = "INAnimacion";
    public static final String OutAnimador = "OUTAnimador";
    private final String fps = "FPS";
    private CoupledSimulacion _simulacion;
    private Camara _camara;
    private Ventana3D _ventanaPrincipal;
    private Ventana2D _ventana2D;
    private ManagerGL3D _managerGL3D;
    private ManagerGL2D _managerGL2D;

    public ManagerVista(ControladorAplicacion control, Terreno terreno, CoupledSimulacion simulacion, int numeroAviones, int numeroBarcos) {
        super("ManagerVista");
        this.addInport(InAnimacion);
        this.addOutport(OutAnimador);
        this.addState("FPS");
        this.setStateValue("FPS", 0);
        this.setSigma(Double.POSITIVE_INFINITY);
        PV3D eye = new PV3D(-100.0f, 100.0f, -100.0f, 1);
        PV3D look = new PV3D(1000.0f, 1000.0f, 1000.0f, 1);
        PV3D up = new PV3D(0.0f, 1.0f, 0.0f, 0);
        this._camara = new Camara(eye, look, up);
        Dibujante dibujante = new Dibujante(terreno, simulacion, this._camara);
        this._simulacion = simulacion;
        this._ventana2D = new Ventana2D(this);
        this._ventana2D.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this._ventana2D.inicializar();
        this._ventana2D.setVisible(false);
        this._ventana2D.setVisible(true);
        int largo = terreno.getLongitud();
        int ancho = terreno.getAnchura();
        this._managerGL2D = new ManagerGL2D(this._ventana2D, 0, largo, 0, ancho, dibujante);
        this._ventana2D.ponerVisual(this._managerGL2D);
        this._ventanaPrincipal = new Ventana3D(this, numeroAviones, numeroBarcos);
        this._ventanaPrincipal.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this._ventanaPrincipal.inicializar();
        this._ventanaPrincipal.setVisible(false);
        this._ventanaPrincipal.setVisible(true);
        this._managerGL3D = new ManagerGL3D(this, -10.0f, 10.0f, -10.0f, 10.0f, 1.0f, 100000.0f, this._ventanaPrincipal, dibujante, this._camara);
    }

    public void setFPS(int FPS) {
        this.setStateValue(this.fps, FPS);
    }

    public void deltext(double e, Message x) {
        Iterator<Object> iteradorInAnimacion = x.getValuesOnPort(InAnimacion).iterator();
        if (iteradorInAnimacion.hasNext()) {
            this._managerGL3D.actualizar();
            this._managerGL2D.actualizar();
            this.setSigma(0.0);
        }
    }

    public void deltint() {
        this.setSigma(Double.POSITIVE_INFINITY);
    }

    public Message lambda() {
        MessageImpl msg = new MessageImpl();
        if (this.getStateValue("FPS").intValue() != 0) {
            msg.add(OutAnimador, this.getStateValue("FPS"));
            this.setStateValue("FPS", 0);
        }
        return msg;
    }

    public void rollTo(float angulo) {
        this._managerGL3D.rollTo(angulo);
    }

    public void yawTo(float angulo) {
        this._managerGL3D.yawTo(angulo);
    }

    public void pitchTo(float angulo) {
        this._managerGL3D.pitchTo(angulo);
    }

    public void desplazar3D(float x, float y, float z) {
        this._managerGL3D.desplazar(x, y, z);
    }

    public void goTo3D(float x, float y, float z) {
        this._managerGL3D.goTo(x, y, z);
    }

    public void movimientoCamara(PV3D camara) {
        this._managerGL2D.actualizar();
    }

    public void zoom2D(float zoom) {
        this._managerGL2D.zoom(zoom);
    }

    public void desplazar2D(float x, float y) {
        if (x < 0.0f) {
            this._managerGL2D.desplazarProporcionadoIzquierda();
        } else if (x > 0.0f) {
            this._managerGL2D.desplazarProporcionadoDerecha();
        }
        if (y < 0.0f) {
            this._managerGL2D.desplazarProporcionadoAbajo();
        } else if (y > 0.0f) {
            this._managerGL2D.desplazarProporcionadoArriba();
        }
    }

    public void anclar(int tipo, int numero) {
        AtomicStateImpl elemento = null;
        int tipoCamara = -1;
        switch (tipo) {
            case 4: {
                tipoCamara = 0;
                elemento = this._simulacion.dameAviones().get(numero).getAvion();
                break;
            }
            case 6: {
                tipoCamara = 1;
                elemento = this._simulacion.dameAviones().get(numero).getAvion();
                break;
            }
            case 8: {
                tipoCamara = 2;
                elemento = this._simulacion.dameAviones().get(numero).getAvion();
                break;
            }
            case 10: {
                tipoCamara = 3;
                elemento = this._simulacion.dameAviones().get(numero).getAvion();
                break;
            }
            case 5: {
                tipoCamara = 0;
                elemento = this._simulacion.dameBarcos().get(numero).getBarco();
                break;
            }
            case 7: {
                tipoCamara = 1;
                elemento = this._simulacion.dameBarcos().get(numero).getBarco();
                break;
            }
            case 9: {
                tipoCamara = 2;
                elemento = this._simulacion.dameBarcos().get(numero).getBarco();
                break;
            }
            case 11: {
                tipoCamara = 3;
                elemento = this._simulacion.dameBarcos().get(numero).getBarco();
            }
        }
        this._camara.anclar((Seguible)((Object)elemento), tipoCamara);
    }

    public void desanclar() {
        this._camara.desanclar();
    }

    public void setVelocidad(int velocidad) {
        this._simulacion.ponVelocidad(velocidad);
    }
}

