/*
 * Decompiled with CFR 0.152.
 */
package proyectoSI.grafico;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import proyectoSI.grafico.ManagerVista;
import proyectoSI.grafico.TreeNode;
import proyectoSI.grafico.TreeRender;
import proyectoSI.grafico.VentanaConfiguracion;

public class Ventana3D
extends JFrame
implements TreeExpansionListener,
TreeSelectionListener {
    private static final long serialVersionUID = 1L;
    private ManagerVista _manager;
    private JSlider _sliderRoll;
    private JSlider _sliderYaw;
    private JSlider _sliderPitch;
    private JSlider _sliderVelocidad;
    private JTextField _anguloRoll;
    private JTextField _anguloYaw;
    private JTextField _anguloPitch;
    private JTextField _desplazamientoX;
    private JTextField _desplazamientoY;
    private JTextField _desplazamientoZ;
    private JTextField _goToX;
    private JTextField _goToY;
    private JTextField _goToZ;
    private JTextField _factorZoom;
    private JButton _aceptarRoll;
    private JButton _aceptarYaw;
    private JButton _aceptarPitch;
    private JButton _aceptarX;
    private JButton _aceptarY;
    private JButton _aceptarZ;
    private JButton _aceptarGoTo;
    private JButton _aceptarZoom;
    private JTree _tree;
    private int _numAviones;
    private int _numBarcos;
    private JLabel _velocidad;

    public Ventana3D(ManagerVista manager, int numAviones, int numBarcos) {
        this._manager = manager;
        this._numAviones = numAviones;
        this._numBarcos = numBarcos;
        this.setTitle("Interfaz de simulaci\ufffdn 3D");
        this.setLayout(new BorderLayout());
    }

    public void inicializar() {
        this.setSize(800, 600);
        this.setLayout(new BorderLayout());
        this.configurarMenu();
        this.configurarPanelSur();
        this.configurarPanelEste();
        this.setVisible(true);
    }

    private void configurarMenu() {
        JMenuBar barraMenu = new JMenuBar();
        JMenuItem configuracion = new JMenuItem("Configuraci\ufffdn");
        barraMenu.add(configuracion);
        this.setJMenuBar(barraMenu);
        this.establecerOyenteConfiguracion(configuracion);
    }

    private void establecerOyenteConfiguracion(AbstractButton configuracion) {
        configuracion.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                VentanaConfiguracion ventana = new VentanaConfiguracion(Ventana3D.this._manager);
                ventana.inicializar();
            }
        });
    }

    private void configurarPanelSur() {
        this._sliderVelocidad = new JSlider(1, 100);
        this.establecerOyenteSliderVelocidad();
        JPanel panelSur = new JPanel();
        panelSur.add(new JLabel("Velocidad de simulaci\ufffdn"));
        panelSur.add(this._sliderVelocidad);
        this._velocidad = new JLabel();
        this._sliderVelocidad.setValue(1);
        panelSur.add(this._velocidad);
        this.add((Component)panelSur, "South");
    }

    private void establecerOyenteSliderVelocidad() {
        this._sliderVelocidad.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evento) {
                Ventana3D.this.cambioSliderVelocidad();
            }
        });
    }

    private void cambioSliderVelocidad() {
        int velocidad = this._sliderVelocidad.getValue();
        this._velocidad.setText(Integer.valueOf(velocidad).toString());
        this._manager.setVelocidad(velocidad);
    }

    private JPanel configurarPanel1() {
        GridBagLayout gridbag = new GridBagLayout();
        JPanel panel1 = new JPanel(gridbag);
        this._aceptarRoll = new JButton("Introducir");
        this._anguloRoll = new JTextField("0.0", 4);
        this._sliderRoll = new JSlider(-1800, 1800);
        this.configurarSlider(panel1, gridbag, "C\u00e1mara: Roll", this._anguloRoll, this._sliderRoll, this._aceptarRoll);
        this.establecerOyenteAceptarRoll();
        this.establecerOyenteSliderRoll();
        this._aceptarYaw = new JButton("Introducir");
        this._anguloYaw = new JTextField("0.0", 4);
        this._sliderYaw = new JSlider(-1800, 1800);
        this.configurarSlider(panel1, gridbag, "C\u00e1mara: Yaw", this._anguloYaw, this._sliderYaw, this._aceptarYaw);
        this.establecerOyenteAceptarYaw();
        this.establecerOyenteSliderYaw();
        this._aceptarPitch = new JButton("Introducir");
        this._anguloPitch = new JTextField("0.0", 4);
        this._sliderPitch = new JSlider(-1800, 1800);
        this.configurarSlider(panel1, gridbag, "C\u00e1mara: Pitch", this._anguloPitch, this._sliderPitch, this._aceptarPitch);
        this.establecerOyenteAceptarPitch();
        this.establecerOyenteSliderPitch();
        return panel1;
    }

    private void configurarSlider(JPanel panel, GridBagLayout gridbag, String text, JTextField angulo, JSlider slider, JButton aceptar) {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        JLabel etiqueta = new JLabel(text, 0);
        gridbag.setConstraints(etiqueta, c);
        panel.add(etiqueta);
        c.weightx = 0.0;
        angulo.setHorizontalAlignment(4);
        gridbag.setConstraints(angulo, c);
        panel.add(angulo);
        c.weightx = 0.0;
        JLabel aux = new JLabel("  ");
        gridbag.setConstraints(aux, c);
        panel.add(aux);
        c.weightx = 0.0;
        gridbag.setConstraints(aceptar, c);
        panel.add(aceptar);
        c.weightx = 0.0;
        c.gridwidth = 0;
        aux = new JLabel("   ");
        gridbag.setConstraints(aux, c);
        panel.add(aux);
        c.weightx = 1.0;
        c.gridwidth = 0;
        gridbag.setConstraints(slider, c);
        panel.add(slider);
    }

    private void establecerOyenteSliderRoll() {
        this._sliderRoll.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evento) {
                Ventana3D.this.cambioSliderRoll();
            }
        });
    }

    private void cambioSliderRoll() {
        float angulo = (float)this._sliderRoll.getValue() / 10.0f;
        this._anguloRoll.setText("" + angulo);
        this._manager.rollTo(angulo);
    }

    private void establecerOyenteAceptarRoll() {
        this._aceptarRoll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evento) {
                Ventana3D.this.aceptarRoll();
            }
        });
    }

    private void aceptarRoll() {
        try {
            float angulo = Float.parseFloat(this._anguloRoll.getText());
            if (angulo <= 180.0f && angulo >= -180.0f) {
                this._sliderRoll.setValue(Float.valueOf(angulo * 10.0f).intValue());
                this._manager.rollTo(angulo);
            }
        }
        catch (Exception e) {
            float anguloAux = (float)this._sliderRoll.getValue() / 10.0f;
            this._anguloRoll.setText("" + anguloAux);
        }
    }

    private void establecerOyenteSliderYaw() {
        this._sliderYaw.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evento) {
                Ventana3D.this.cambioSliderYaw();
            }
        });
    }

    private void cambioSliderYaw() {
        float angulo = (float)this._sliderYaw.getValue() / 10.0f;
        this._anguloYaw.setText("" + angulo);
        this._manager.yawTo(angulo);
    }

    private void establecerOyenteAceptarYaw() {
        this._aceptarYaw.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evento) {
                Ventana3D.this.aceptarYaw();
            }
        });
    }

    private void aceptarYaw() {
        try {
            float angulo = Float.parseFloat(this._anguloYaw.getText());
            if (angulo <= 180.0f && angulo >= -180.0f) {
                this._sliderYaw.setValue(Float.valueOf(angulo * 10.0f).intValue());
                this._manager.yawTo(angulo);
            }
        }
        catch (Exception e) {
            float anguloAux = (float)this._sliderYaw.getValue() / 10.0f;
            this._anguloYaw.setText("" + anguloAux);
        }
    }

    private void establecerOyenteSliderPitch() {
        this._sliderPitch.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evento) {
                Ventana3D.this.cambioSliderPitch();
            }
        });
    }

    private void cambioSliderPitch() {
        float angulo = (float)this._sliderPitch.getValue() / 10.0f;
        this._anguloPitch.setText("" + angulo);
        this._manager.pitchTo(angulo);
    }

    private void establecerOyenteAceptarPitch() {
        this._aceptarPitch.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evento) {
                Ventana3D.this.aceptarPitch();
            }
        });
    }

    private void aceptarPitch() {
        try {
            float angulo = Float.parseFloat(this._anguloPitch.getText());
            if (angulo <= 180.0f && angulo >= -180.0f) {
                this._sliderPitch.setValue(Float.valueOf(angulo * 10.0f).intValue());
                this._manager.pitchTo(angulo);
            }
        }
        catch (Exception e) {
            float anguloAux = (float)this._sliderPitch.getValue() / 10.0f;
            this._anguloPitch.setText("" + anguloAux);
        }
    }

    private JPanel configurarPanel2() {
        JPanel panel2 = new JPanel(new GridLayout(4, 1));
        this._aceptarX = new JButton("Introducir");
        this._desplazamientoX = new JTextField("0.0", 4);
        JPanel panel21 = new JPanel();
        this.configurarSolicitud(panel21, "C\ufffdmara: Desp. eje X", this._desplazamientoX, this._aceptarX);
        this.establecerOyenteAceptarX();
        this._aceptarY = new JButton("Introducir");
        this._desplazamientoY = new JTextField("0.0", 4);
        JPanel panel22 = new JPanel();
        this.configurarSolicitud(panel22, "C\ufffdmara: Desp. eje Y", this._desplazamientoY, this._aceptarY);
        this.establecerOyenteAceptarY();
        this._aceptarZ = new JButton("Introducir");
        this._desplazamientoZ = new JTextField("0.0", 4);
        JPanel panel23 = new JPanel();
        this.configurarSolicitud(panel23, "C\ufffdmara: Desp. eje Z", this._desplazamientoZ, this._aceptarZ);
        this.establecerOyenteAceptarZ();
        this._aceptarZoom = new JButton("Introducir");
        this._factorZoom = new JTextField("0.0", 4);
        JPanel panel24 = new JPanel();
        this.configurarSolicitud(panel24, "C\ufffdmara: Zoom (x)", this._factorZoom, this._aceptarZoom);
        panel2.add(panel21);
        panel2.add(panel22);
        panel2.add(panel23);
        panel2.add(panel24);
        return panel2;
    }

    private void establecerOyenteAceptarX() {
        this._aceptarX.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evento) {
                Ventana3D.this.aceptarX();
            }
        });
    }

    private void aceptarX() {
        try {
            float desp = Float.parseFloat(this._desplazamientoX.getText());
            this._manager.desplazar3D(desp, 0.0f, 0.0f);
        }
        catch (Exception e) {
            this._desplazamientoX.setText("0.0");
        }
    }

    private void establecerOyenteAceptarY() {
        this._aceptarY.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evento) {
                Ventana3D.this.aceptarY();
            }
        });
    }

    private void aceptarY() {
        try {
            float desp = Float.parseFloat(this._desplazamientoY.getText());
            this._manager.desplazar3D(0.0f, desp, 0.0f);
        }
        catch (Exception e) {
            this._desplazamientoY.setText("0.0");
        }
    }

    private void establecerOyenteAceptarZ() {
        this._aceptarZ.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evento) {
                Ventana3D.this.aceptarZ();
            }
        });
    }

    private void aceptarZ() {
        try {
            float desp = Float.parseFloat(this._desplazamientoZ.getText());
            this._manager.desplazar3D(0.0f, 0.0f, desp);
        }
        catch (Exception e) {
            this._desplazamientoZ.setText("0.0");
        }
    }

    private void configurarSolicitud(JPanel panel, String text, JTextField desplazamiento, JButton aceptar) {
        GridBagLayout gridbag = new GridBagLayout();
        panel.setLayout(gridbag);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        JLabel etiqueta = new JLabel(text, 0);
        gridbag.setConstraints(etiqueta, c);
        panel.add(etiqueta);
        c.weightx = 0.0;
        desplazamiento.setHorizontalAlignment(4);
        gridbag.setConstraints(desplazamiento, c);
        panel.add(desplazamiento);
        c.weightx = 0.0;
        JLabel aux = new JLabel(" ");
        gridbag.setConstraints(aux, c);
        panel.add(aux);
        c.weightx = 0.0;
        c.gridwidth = 0;
        gridbag.setConstraints(aceptar, c);
        panel.add(aceptar);
    }

    private void establecerOyenteAceptarGoTo() {
        this._aceptarGoTo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evento) {
                Ventana3D.this.goTo();
            }
        });
    }

    private void goTo() {
        try {
            float x = Float.parseFloat(this._goToX.getText());
            float y = Float.parseFloat(this._goToY.getText());
            float z = Float.parseFloat(this._goToZ.getText());
            this._manager.goTo3D(x, y, z);
        }
        catch (Exception e) {
            this._goToX.setText("0.0");
            this._goToY.setText("0.0");
            this._goToZ.setText("0.0");
        }
    }

    private void configurarGoTo(JPanel panel, String text, JTextField x, JTextField y, JTextField z, JButton aceptar) {
        GridBagLayout gridbag = new GridBagLayout();
        panel.setLayout(gridbag);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        JLabel etiqueta = new JLabel(text, 0);
        gridbag.setConstraints(etiqueta, c);
        panel.add(etiqueta);
        c.weightx = 0.0;
        JLabel aux = new JLabel(" X:", 4);
        gridbag.setConstraints(aux, c);
        panel.add(aux);
        c.weightx = 0.0;
        x.setHorizontalAlignment(4);
        gridbag.setConstraints(x, c);
        panel.add(x);
        c.weightx = 0.0;
        aux = new JLabel(" Y:", 4);
        gridbag.setConstraints(aux, c);
        panel.add(aux);
        c.weightx = 0.0;
        y.setHorizontalAlignment(4);
        gridbag.setConstraints(y, c);
        panel.add(y);
        c.weightx = 0.0;
        aux = new JLabel(" Z:", 4);
        gridbag.setConstraints(aux, c);
        panel.add(aux);
        c.weightx = 0.0;
        z.setHorizontalAlignment(4);
        gridbag.setConstraints(z, c);
        panel.add(z);
        c.weightx = 0.0;
        aux = new JLabel("  ");
        gridbag.setConstraints(aux, c);
        panel.add(aux);
        c.gridwidth = 0;
        gridbag.setConstraints(aceptar, c);
        panel.add(aceptar);
    }

    private JPanel configurarPanel3() {
        return new JPanel();
    }

    private void configurarPanelEste() {
        DefaultMutableTreeNode top = new DefaultMutableTreeNode(new TreeNode(14, -1));
        this.crearNodos(top);
        this._tree = new JTree(top);
        this._tree.getSelectionModel().setSelectionMode(1);
        this._tree.addTreeExpansionListener(this);
        this._tree.addTreeSelectionListener(this);
        this._tree.setCellRenderer(new TreeRender());
        JScrollPane treeView = new JScrollPane(this._tree);
        this.add((Component)treeView, "East");
    }

    private void crearNodos(DefaultMutableTreeNode top) {
        DefaultMutableTreeNode elemento;
        int i;
        DefaultMutableTreeNode aviones = null;
        DefaultMutableTreeNode barcos = null;
        aviones = new DefaultMutableTreeNode(new TreeNode(1, -1));
        top.add(aviones);
        for (i = 0; i < this._numAviones; ++i) {
            elemento = new DefaultMutableTreeNode(new TreeNode(0, i));
            elemento.add(new DefaultMutableTreeNode(new TreeNode(4, i)));
            elemento.add(new DefaultMutableTreeNode(new TreeNode(6, i)));
            elemento.add(new DefaultMutableTreeNode(new TreeNode(8, i)));
            elemento.add(new DefaultMutableTreeNode(new TreeNode(10, i)));
            elemento.add(new DefaultMutableTreeNode(new TreeNode(12, i)));
            aviones.add(elemento);
        }
        barcos = new DefaultMutableTreeNode(new TreeNode(3, -1));
        top.add(barcos);
        for (i = 0; i < this._numAviones; ++i) {
            elemento = new DefaultMutableTreeNode(new TreeNode(2, i));
            elemento.add(new DefaultMutableTreeNode(new TreeNode(5, i)));
            elemento.add(new DefaultMutableTreeNode(new TreeNode(7, i)));
            elemento.add(new DefaultMutableTreeNode(new TreeNode(9, i)));
            elemento.add(new DefaultMutableTreeNode(new TreeNode(11, i)));
            elemento.add(new DefaultMutableTreeNode(new TreeNode(13, i)));
            barcos.add(elemento);
        }
    }

    public void valueChanged(TreeSelectionEvent arg0) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this._tree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        TreeNode nodeInfo = (TreeNode)node.getUserObject();
        if (node.isLeaf()) {
            this._manager.anclar(nodeInfo.getTipo(), nodeInfo.getNumero());
        } else {
            this._manager.desanclar();
        }
    }

    public void treeCollapsed(TreeExpansionEvent arg0) {
        this.setVisible(true);
    }

    public void treeExpanded(TreeExpansionEvent arg0) {
        this.setVisible(true);
    }
}

