/*
 * Decompiled with CFR 0.152.
 */
package proyectoSI.grafico.estructura;

import javax.media.opengl.GL;
import proyectoSI.grafico.estructura.Cara;
import proyectoSI.grafico.estructura.Color;
import proyectoSI.grafico.estructura.Objeto3D;
import proyectoSI.grafico.estructura.PV3D;

public abstract class ObjetoDegradado
extends Objeto3D {
    private int _nVertices;
    private int _nNormales;
    private int _nCaras;
    private Cara[] _caras;
    private PV3D[] _normales;
    private PV3D[] _vertices;
    private Color[] _colores;

    public ObjetoDegradado() {
        this._nVertices = 0;
        this._nNormales = 0;
        this._nCaras = 0;
        this._caras = null;
        this._normales = null;
        this._vertices = null;
        this._colores = null;
    }

    public ObjetoDegradado(int nVertices, int nNormales, int nCaras, Cara[] caras, PV3D[] normales, PV3D[] vertices, Color[] colores) {
        this._nVertices = nVertices;
        this._nNormales = nNormales;
        this._nCaras = nCaras;
        this._caras = caras;
        this._normales = normales;
        this._vertices = vertices;
    }

    public void setNVertices(int nVertices) {
        this._nVertices = nVertices;
    }

    public int getNVertices() {
        return this._nVertices;
    }

    public void setNNormales(int nNormales) {
        this._nNormales = nNormales;
    }

    public int getNNormales() {
        return this._nNormales;
    }

    public void setNCaras(int nCaras) {
        this._nCaras = nCaras;
    }

    public int getNCaras() {
        return this._nCaras;
    }

    public void setCaras(Cara[] caras) {
        this._caras = caras;
    }

    public Cara[] getCaras() {
        return this._caras;
    }

    public void setNormales(PV3D[] normales) {
        this._normales = normales;
    }

    public PV3D[] getNormales() {
        return this._normales;
    }

    public void setVertices(PV3D[] vertices) {
        this._vertices = vertices;
    }

    public PV3D[] getVertices() {
        return this._vertices;
    }

    public void setColores(Color[] colores) {
        this._colores = colores;
    }

    public Color[] getColores() {
        return this._colores;
    }

    public abstract void dibujar3D(GL var1);

    public void calcularNormalesNewell() {
        for (int i = 0; i < this._nNormales; ++i) {
            float nx = 0.0f;
            float ny = 0.0f;
            float nz = 0.0f;
            for (int j = 0; j < this._caras[i].getNumVertices(); ++j) {
                PV3D actual = this._vertices[this._caras[i].getVerticeNormal()[j].getVertice()];
                int suc = j == this._caras[i].getNumVertices() - 1 ? 0 : j + 1;
                PV3D sucesor = this._vertices[this._caras[i].getVerticeNormal()[suc].getVertice()];
                nx += (actual.getY() - sucesor.getY()) * (actual.getZ() + sucesor.getZ());
                ny += (actual.getZ() - sucesor.getZ()) * (actual.getX() + sucesor.getX());
                nz += (actual.getX() - sucesor.getX()) * (actual.getY() + sucesor.getY());
            }
            this._normales[i] = new PV3D(nx, ny, nz);
        }
    }

    public void invertirNormales() {
        for (int i = 0; i < this._nNormales; ++i) {
            this._normales[i].setX(-this._normales[i].getX());
            this._normales[i].setY(-this._normales[i].getY());
            this._normales[i].setZ(-this._normales[i].getZ());
        }
    }
}

