/*
 * Decompiled with CFR 0.152.
 */
package proyectoSI.modelo;

import java.util.ArrayList;
import javax.media.opengl.GL;
import proyectoSI.Mux.Mux;
import proyectoSI.aviones.UAV;
import proyectoSI.barcos.Barco;
import proyectoSI.grafico.Dibujable;
import proyectoSI.grafico.estructura.terreno.Terreno;
import proyectoSI.incidencias.Naufrago;
import proyectoSI.modelo.RelojGE;
import proyectoSI.modelo.RelojState;
import proyectoSI.simulacion.Controlador;
import xdevs.kernel.modeling.CoupledImpl;
import xdevs.kernel.simulation.CoordinatorImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoupledSimulacion
extends CoupledImpl
implements Dibujable,
Runnable {
    ArrayList<UAV> _aviones = new ArrayList();
    ArrayList<Barco> _barcos = new ArrayList();
    ArrayList<Naufrago> _naufragos = new ArrayList();
    Controlador _controlador;
    Terreno _terreno;
    RelojState _reloj;
    RelojGE _relojge;
    Mux _muxaviones;
    Mux _muxbarcos;
    Mux _muxcaviones;
    Mux _muxcbarcos;
    Mux _muxnaufragos;

    public CoupledSimulacion(String name, int numaviones, int numbarcos, int num_naufragos, int tiempo, Terreno terreno, boolean guardarArchivo, String nombreSimulacion, boolean XmlOSer, long t_gearth, Double velocidad_avion, Double posicionnavion, Double posicioneavion, Double distanciaavion, Double posicionnbarco, Double posicionebarco, Double distanciabarco, boolean rescatanaviones) {
        super(name);
        int i;
        this._muxaviones = new Mux("muxaviones", numaviones);
        this._muxbarcos = new Mux("muxbarcos", numbarcos);
        this._muxcbarcos = new Mux("muxcbarcos", numbarcos);
        this._muxcaviones = new Mux("muxcaviones", numaviones);
        this._muxnaufragos = new Mux("muxnaufragos", num_naufragos);
        this._controlador = new Controlador("ayd", tiempo, numaviones, numbarcos, num_naufragos, guardarArchivo, nombreSimulacion, XmlOSer, velocidad_avion, posicionnavion, posicioneavion, distanciaavion, posicionnbarco, posicionebarco, distanciabarco, rescatanaviones);
        this._reloj = new RelojState("reloj", 10);
        this._relojge = new RelojGE("reloj g.earth", t_gearth, this);
        new Thread(this._relojge).start();
        this._terreno = terreno;
        this.addComponent(this._muxaviones);
        this.addComponent(this._muxbarcos);
        this.addComponent(this._muxcaviones);
        this.addComponent(this._muxcbarcos);
        this.addComponent(this._muxnaufragos);
        this.addComponent(this._controlador);
        this.addComponent(this._reloj);
        this.addComponent(this._relojge);
        this.addCoupling(this._reloj, "OUT", this._controlador, "INR");
        this.addCoupling(this._controlador, "salidaGoogle", this._relojge, "IN");
        for (i = 0; i < numaviones; ++i) {
            UAV uav = new UAV(i, this._terreno);
            this._aviones.add(uav);
            this.addComponent(uav);
            this.addCoupling(uav, "Out", this._muxaviones, this._muxaviones.In[i]);
            this.addCoupling(this._muxaviones, this._muxaviones.Out, this._controlador, "INA");
            this.addCoupling(uav, "Outcontrolador", this._muxcaviones, this._muxcaviones.In[i]);
            this.addCoupling(this._muxcaviones, this._muxcaviones.Out, this._controlador, "INCA");
            this.addCoupling(this._controlador, "OUTA", uav, "In");
            this.addCoupling(this._controlador, "OUTCA", uav, "Incontrolador");
        }
        for (i = 0; i < numbarcos; ++i) {
            Barco barco = new Barco(numaviones + i, this._terreno);
            this._barcos.add(barco);
            this.addComponent(barco);
            this.addCoupling(barco, "Out", this._muxbarcos, this._muxbarcos.In[i]);
            this.addCoupling(this._muxbarcos, this._muxbarcos.Out, this._controlador, "INB");
            this.addCoupling(this._controlador, "OUTB", barco, "In");
            this.addCoupling(barco, "Outcontrolador", this._muxcbarcos, this._muxcbarcos.In[i]);
            this.addCoupling(this._muxcbarcos, this._muxcbarcos.Out, this._controlador, "INCB");
            this.addCoupling(this._controlador, "OUTCB", barco, "INCB");
        }
        for (i = 0; i < num_naufragos; ++i) {
            Naufrago naufrago = new Naufrago(Integer.valueOf(i).toString(), tiempo, terreno);
            this._naufragos.add(naufrago);
            this.addComponent(naufrago);
            this.addCoupling(this._controlador, "OUTN", naufrago, "INsolicitud");
            this.addCoupling(naufrago, "OUT", this._muxnaufragos, this._muxnaufragos.In[i]);
            this.addCoupling(this._muxnaufragos, this._muxnaufragos.Out, this._controlador, "INN");
        }
    }

    public ArrayList<UAV> dameAviones() {
        return this._aviones;
    }

    public ArrayList<Barco> dameBarcos() {
        return this._barcos;
    }

    @Override
    public void dibujar2D(GL gl) {
        int i;
        for (i = 0; i < this._aviones.size(); ++i) {
            this._aviones.get(i).getAvion().dibujar2D(gl);
        }
        for (i = 0; i < this._barcos.size(); ++i) {
            this._barcos.get(i).getBarco().dibujar2D(gl);
        }
        for (i = 0; i < this._naufragos.size(); ++i) {
            this._naufragos.get(i).dibujar2D(gl);
        }
    }

    @Override
    public void dibujar3D(GL gl) {
        int i;
        for (i = 0; i < this._aviones.size(); ++i) {
            this._aviones.get(i).getAvion().dibujar3D(gl);
        }
        for (i = 0; i < this._barcos.size(); ++i) {
            this._barcos.get(i).getBarco().dibujar3D(gl);
        }
        for (i = 0; i < this._naufragos.size(); ++i) {
            this._naufragos.get(i).dibujar3D(gl);
        }
    }

    @Override
    public void inicializar(GL gl) {
        int i;
        for (i = 0; i < this._aviones.size(); ++i) {
            this._aviones.get(i).getAvion().inicializar(gl);
        }
        for (i = 0; i < this._barcos.size(); ++i) {
            this._barcos.get(i).getBarco().inicializar(gl);
        }
        for (i = 0; i < this._naufragos.size(); ++i) {
            this._naufragos.get(i).inicializar(gl);
        }
    }

    @Override
    public void run() {
        CoordinatorImpl coordinator = new CoordinatorImpl(this);
        coordinator.simulate(Integer.MAX_VALUE);
    }

    public void ponVelocidadVista(double numVecesMasRapido) {
        this._reloj.ponVelocidad(numVecesMasRapido);
    }

    public void ponVelocidad(int numVeces) {
        this._reloj.ponVelocidad(numVeces);
    }
}

