/*
 * Decompiled with CFR 0.152.
 */
package proyectoSI.xml;

import java.io.File;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Xml {
    public Document readFile(String filename) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            Document doc = factory.newDocumentBuilder().parse(new File(filename));
            return doc;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void writeFile(Document doc, String filename) {
        try {
            DOMSource source = new DOMSource(doc);
            File file = new File(filename);
            StreamResult result = new StreamResult(file);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.transform(source, result);
            System.out.println(filename);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ArrayList leer(String filename) {
        Document doc = this.readFile(filename);
        ArrayList puntos = null;
        Element elemento = doc.getDocumentElement();
        if (elemento.hasChildNodes()) {
            NodeList lista = elemento.getElementsByTagName("Point");
            puntos = new ArrayList(lista.getLength());
            for (int i = 0; i < lista.getLength(); ++i) {
                ArrayList<String> info = new ArrayList<String>(4);
                Element elem = (Element)lista.item(i);
                NodeList lista1 = elem.getElementsByTagName("X");
                info.add(lista1.item(0).getTextContent());
                NodeList lista2 = elem.getElementsByTagName("Y");
                info.add(lista2.item(0).getTextContent());
                NodeList lista3 = elem.getElementsByTagName("Z");
                info.add(lista3.item(0).getTextContent());
                NodeList lista4 = elem.getElementsByTagName("V");
                info.add(lista4.item(0).getTextContent());
                puntos.add(info);
            }
        }
        return puntos;
    }

    public void escribir(ArrayList datos, int[][] tabla, String archivo) {
        Document document = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.newDocument();
            Element root = document.createElement("Resultados");
            root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            root.setAttribute("xsi:noNamespaceSchemaLocation", "Esquema2.xsd");
            document.appendChild(root);
            int tam = tabla.length % 2 == 0 ? tabla.length - 1 : tabla.length;
            for (int i = 0; i < datos.size(); ++i) {
                Element participante = document.createElement("Participante");
                Element atr = document.createElement("Nombre");
                atr.setTextContent(((String[])datos.get(i))[0]);
                participante.appendChild(atr);
                atr = document.createElement("Apellido1");
                atr.setTextContent(((String[])datos.get(i))[1]);
                participante.appendChild(atr);
                atr = document.createElement("Apellido2");
                atr.setTextContent(((String[])datos.get(i))[2]);
                participante.appendChild(atr);
                atr = document.createElement("dni");
                atr.setTextContent(((String[])datos.get(i))[3]);
                participante.appendChild(atr);
                atr = document.createElement("enfrentamientos");
                for (int j = 0; j < tam; ++j) {
                    Element atr2;
                    Element atr1 = document.createElement("oponente");
                    if (tabla[i][j] > datos.size()) {
                        atr2 = document.createElement("dni");
                        atr2.setTextContent("descansa");
                        atr1.appendChild(atr2);
                        atr2 = document.createElement("Dia");
                        atr2.setTextContent(j + 1 + "");
                        atr1.appendChild(atr2);
                        atr.appendChild(atr1);
                        continue;
                    }
                    atr2 = document.createElement("dni");
                    atr2.setTextContent(((String[])datos.get(tabla[i][j] - 1))[3]);
                    atr1.appendChild(atr2);
                    atr2 = document.createElement("Dia");
                    atr2.setTextContent(j + 1 + "");
                    atr1.appendChild(atr2);
                    atr.appendChild(atr1);
                }
                participante.appendChild(atr);
                root.appendChild(participante);
            }
            this.writeFile(document, archivo);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }
}

