/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.util.Collection;
import test.Job;
import xdevs.kernel.modeling.AtomicImpl;
import xdevs.kernel.modeling.MessageImpl;
import xdevs.kernel.modeling.api.Message;

public class Generator
extends AtomicImpl {
    public static final String stop = "stop";
    public static final String out = "out";
    protected double period;
    protected int count;

    public Generator() {
        super("Generator");
        this.addInport(stop);
        this.addOutport(out);
        this.period = 1.0;
        this.setSigma(this.period);
        this.count = 0;
    }

    public Generator(String name, double period) {
        super(name);
        this.addInport(stop);
        this.addOutport(out);
        this.period = period;
        this.setSigma(period);
        this.count = 0;
    }

    public void deltint() {
        ++this.count;
        this.setSigma(this.period);
    }

    public void deltext(double e, Message x) {
        this.setSigma(this.getSigma() - e);
        Collection<Object> values = x.getValuesOnPort(stop);
        if (!values.isEmpty()) {
            this.setSigma(Double.POSITIVE_INFINITY);
        }
    }

    public Message lambda() {
        Job job = new Job("" + this.count + "");
        MessageImpl msg = new MessageImpl();
        msg.add(out, job);
        return msg;
    }

    public double getPeriod() {
        return this.period;
    }

    public void setPeriod(double period) {
        this.period = period;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }
}

