/*
 * Decompiled with CFR 0.152.
 */
package test.josele.mealyandmoore;

import java.util.Iterator;
import xdevs.kernel.modeling.AtomicImpl;
import xdevs.kernel.modeling.MessageImpl;
import xdevs.kernel.modeling.api.Message;

public class WeightedSum
extends AtomicImpl {
    public static final String out = "out";
    protected double[] weights;
    protected double[] inputs;
    protected boolean[] checkInputs;
    protected boolean sendOutput;

    public WeightedSum(String name, double[] weights) {
        super(name);
        int i;
        this.checkInputs = new boolean[weights.length];
        for (i = 0; i < weights.length; ++i) {
            super.addInport("in" + i);
            this.checkInputs[i] = false;
        }
        super.addOutport(out);
        this.weights = weights;
        this.inputs = new double[this.weights.length];
        for (i = 0; i < this.weights.length; ++i) {
            this.inputs[i] = 0.0;
        }
    }

    public void deltint() {
        if (this.sendOutput) {
            for (int i = 0; i < this.inputs.length; ++i) {
                this.checkInputs[i] = false;
            }
            super.setSigma(Double.POSITIVE_INFINITY);
        }
    }

    public void deltext(double e, Message x) {
        int i;
        for (i = 0; i < this.weights.length; ++i) {
            Iterator<Object> itr = x.getValuesOnPort("in" + i).iterator();
            if (!itr.hasNext()) continue;
            this.inputs[i] = (Double)itr.next();
            this.checkInputs[i] = true;
        }
        this.sendOutput = true;
        for (i = 0; i < this.inputs.length && this.sendOutput; ++i) {
            this.sendOutput = this.sendOutput && this.checkInputs[i];
        }
        if (this.sendOutput) {
            super.setSigma(0.0);
        }
    }

    public Message lambda() {
        MessageImpl msg = new MessageImpl();
        double y = 0.0;
        for (int i = 0; i < this.inputs.length; ++i) {
            y += this.weights[i] * this.inputs[i];
        }
        msg.add(out, y);
        System.out.println(super.getName() + "-->" + y);
        return msg;
    }
}

