/*
 * Decompiled with CFR 0.152.
 */
package xdevs.dtss.mealy.atomic.sinks;

import extra.views.ScopeView;
import java.util.Iterator;
import xdevs.dtss.mealy.atomic.AtomicMealy;
import xdevs.kernel.modeling.api.Message;

public class Scope
extends AtomicMealy {
    public static final String in = "in";
    protected double clock;
    protected ScopeView chart;
    protected String topTitle;
    protected boolean firstDeltExt;

    public Scope(String name) {
        super(name);
        super.addInport(in);
        this.chart = new ScopeView(name, "title", "xTitle", "yTitle");
        this.chart.setMode(ScopeView.MODE.XYStep);
        this.chart.setXTitle("time");
        this.chart.setYTitle("values");
        this.clock = 0.0;
        this.firstDeltExt = true;
    }

    public void deltint() {
        this.clock += super.getSigma();
        super.setSigma(Double.POSITIVE_INFINITY);
    }

    public void deltext(double e, Message x) {
        this.clock += e;
        for (String portName : super.getInportNames()) {
            Iterator<Object> itr = x.getValuesOnPort(portName).iterator();
            if (!itr.hasNext()) continue;
            Object input = itr.next();
            if (input.getClass().isArray()) {
                double[] inputAsArray = (double[])input;
                if (this.firstDeltExt) {
                    for (int i = 0; i < inputAsArray.length; ++i) {
                        this.chart.addSerie(super.getName() + "[" + i + "]");
                    }
                    this.firstDeltExt = false;
                }
                this.chart.add(this.clock, inputAsArray, portName);
                continue;
            }
            double y = (Double)input;
            if (this.firstDeltExt) {
                this.chart.addSerie(super.getName());
                this.firstDeltExt = false;
            }
            this.chart.add(this.clock, y, portName);
        }
    }

    public Message lambda() {
        return null;
    }

    public void setTitle(String title) {
        this.chart.setTitle(title);
    }

    public void setXTitle(String title) {
        this.chart.setXTitle(title);
    }

    public void setYTitle(String title) {
        this.chart.setYTitle(title);
    }
}

