/*
 * Decompiled with CFR 0.152.
 */
package xdevs.kernel.simulation;

import xdevs.kernel.modeling.api.Coupled;
import xdevs.kernel.simulation.CoordinatorImpl;
import xdevs.kernel.simulation.api.RTCentralCoordinator;

public class RTCentralCoordinatorImpl
extends CoordinatorImpl
implements RTCentralCoordinator {
    protected long numIterations;
    protected Thread myThread;

    public RTCentralCoordinatorImpl(Coupled digraph) {
        super(digraph);
        super.initialize(System.currentTimeMillis() / 1000L);
        this.numIterations = 0L;
        this.myThread = new Thread(this);
    }

    public void simulate(long numIterations) {
        this.numIterations = numIterations;
        this.myThread.start();
    }

    public void run() {
        long counter;
        double t = this.tN;
        for (counter = 1L; counter < this.numIterations && t < Double.POSITIVE_INFINITY; ++counter) {
            while ((double)System.currentTimeMillis() < 1000.0 * t - 10.0) {
                long timeSleeping = (long)(1000.0 * t - (double)System.currentTimeMillis());
                if (timeSleeping < 0L) continue;
                try {
                    Thread.sleep(timeSleeping);
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
            }
            this.lambda(t);
            this.deltfcn(t);
            t = this.tN;
        }
        System.out.println(counter + " iterations.");
    }
}

