/*
 * Decompiled with CFR 0.152.
 */
package extra.profile;

import extra.profile.ProfileEntity;
import genDevs.modeling.atomic;
import genDevs.modeling.message;
import moea.commons.ObjectiveVector;
import moea.commons.Population;
import moea.commons.comparator.ComparatorObjective;
import moea.moga.algorithms.Moea;
import moea.moga.algorithms.Nsga2;
import moea.moga.algorithms.Spea2;
import moea.moga.examples.Profile;
import moea.moga.genome.Chromosome;

public class ProfileGeneticAlgorithm
extends atomic {
    private static final long serialVersionUID = 1L;
    protected Integer popSize;
    protected Double probCross;
    protected Double probMut;
    protected Integer maxGenerations;
    protected String algorithmName;
    protected String proPath;
    protected Moea algorithm;
    protected Chromosome sendChromosome;
    protected Long startTime;

    public ProfileGeneticAlgorithm(String name, String proPath, String algorithmName, Integer popSize, Integer maxGenerations, Double probCross, Double probMut) {
        super(name);
        this.proPath = proPath;
        this.maxGenerations = maxGenerations;
        this.algorithmName = algorithmName;
        this.popSize = popSize;
        this.probCross = probCross;
        this.probMut = probMut;
        this.algorithm = null;
        this.sendChromosome = null;
    }

    @Override
    public void initialize() {
        super.initialize();
        Profile.initializeProblem(this.proPath);
        Population<Chromosome> population = new Population<Chromosome>();
        int i = 0;
        while (i < this.popSize) {
            Profile individual = new Profile();
            population.add(individual);
            ++i;
        }
        if (this.algorithmName.equals("NSGA-II")) {
            this.algorithm = new Nsga2(this.name, population, this.maxGenerations, this.probCross, this.probMut);
        } else if (this.algorithmName.equals("SPEA2")) {
            this.algorithm = new Spea2(this.name, population, this.maxGenerations, this.probCross, this.probMut);
        }
        this.sendChromosome = null;
        super.holdIn("initialize", 0.0);
        this.startTime = System.currentTimeMillis();
    }

    @Override
    public void deltint() {
        this.sendChromosome = null;
        if (super.phaseIs("initialize")) {
            this.algorithm.start();
            super.holdIn("running", 10.0);
        } else if (super.phaseIs("sending")) {
            this.algorithm.resumeEvolution();
            super.holdIn("running", 10.0);
        } else if (super.phaseIs("passive")) {
            super.holdIn("passive", 10.0);
        } else if (super.phaseIs("running")) {
            this.algorithm.pauseEvolution();
            if (this.algorithm.done()) {
                super.holdIn("passive", 10.0);
                Long endTime = System.currentTimeMillis();
                Double lifeTime = (1.0 * (double)endTime.longValue() - 1.0 * (double)this.startTime.longValue()) / 1000.0;
                System.out.println(String.valueOf(this.getName()) + " was running for " + lifeTime);
                this.printParetoFront();
            } else {
                Population<Chromosome> popAux = new Population<Chromosome>();
                popAux.add(this.algorithm.getPopulation());
                popAux.keepNonDominated();
                if (popAux.size() > 0) {
                    this.sendChromosome = (Chromosome)popAux.getBestIndividual(ComparatorObjective.getInstance((int)(Math.random() * (double)Chromosome.getN())));
                    System.out.println(String.valueOf(this.getName()) + " deltint(" + this.algorithm.getCurrentGeneration() + "): Sending chromosome...");
                }
                super.holdIn("sending", 0.0);
            }
        }
    }

    @Override
    public void deltext(double e, message x) {
        this.Continue(e);
        if (super.phaseIs("passive")) {
            return;
        }
        int i = 0;
        while (i < x.getLength()) {
            if (this.messageOnPort(x, "in", i)) {
                this.algorithm.pauseEvolution();
                ProfileEntity externalIndividual = (ProfileEntity)x.getValOnPort("in", i);
                Population<Chromosome> population = new Population<Chromosome>();
                population.add(externalIndividual.getChromosome());
                System.out.println(String.valueOf(this.getName()) + " deltext(" + this.algorithm.getCurrentGeneration() + "): Chromosome received.");
                this.algorithm.receive(population);
                this.algorithm.resumeEvolution();
            }
            ++i;
        }
    }

    @Override
    public void deltcon(double e, message x) {
        this.deltext(0.0, x);
        this.deltint();
    }

    @Override
    public message out() {
        message m = new message();
        if (this.sendChromosome != null) {
            ProfileEntity bestEntity = new ProfileEntity();
            bestEntity.setChromosome(this.sendChromosome);
            m.add(this.makeContent("out", bestEntity));
            System.out.println(String.valueOf(this.getName()) + " lambda(" + this.algorithm.getCurrentGeneration() + "): Chromosome sent.");
        }
        return m;
    }

    private void printParetoFront() {
        Population<Chromosome> pop = this.algorithm.getPopulation();
        pop.keepNonDominated();
        for (Chromosome crom : pop) {
            ObjectiveVector objs = crom.getObjectiveVector();
            int i = 0;
            while (i < objs.size()) {
                System.out.print(objs.get(i) + "\t");
                ++i;
            }
            System.out.println("");
        }
    }
}

