/*
 * Decompiled with CFR 0.152.
 */
package genDevs.plots;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class CellGridView
extends JFrame {
    private static final long serialVersionUID = 1L;
    protected Color[][] grid;
    protected GridPanel gridPanel;
    protected Dimension spaceSize = new Dimension(40, 40);
    protected int cellSize = 10;
    protected double xScaleFactor = 1.0;
    protected double yScaleFactor = 1.0;
    protected Font labelFont = new Font("SansSerif", 0, 12);
    protected FontMetrics labelFontMetrics = this.getFontMetrics(this.labelFont);
    protected int labelFontAscent = this.labelFontMetrics.getAscent();
    protected String xLabel = "X";
    protected String yLabel = "Y";
    protected final int borderWidth = 5;

    public CellGridView(String title, Dimension spaceSize_, int cellSize_, String xLabel_, String yLabel_) {
        super(title);
        if (xLabel_ != null) {
            this.xLabel = xLabel_;
        }
        if (yLabel_ != null) {
            this.yLabel = yLabel_;
        }
        if (spaceSize_ != null) {
            this.spaceSize = spaceSize_;
        }
        if (cellSize_ > 0) {
            this.cellSize = cellSize_;
        }
        this.createGrid();
        Container pane = this.getContentPane();
        pane.setBackground(Color.white);
        pane.setLayout(new BorderLayout());
        JPanel main = new JPanel();
        main.setLayout(new BorderLayout());
        main.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        pane.add((Component)main, "Center");
        this.gridPanel = new GridPanel();
        main.add((Component)this.gridPanel, "Center");
    }

    public CellGridView(String title, Dimension spaceSize, int cellSize) {
        this(title, spaceSize, cellSize, null, null);
    }

    public CellGridView(String title, String xLabel, String yLabel) {
        this(title, null, 0, xLabel, yLabel);
    }

    public CellGridView(String title) {
        this(title, null, 0);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.adjustSizeToHoldGridPanel();
    }

    protected void adjustSizeToHoldGridPanel() {
        Insets insets = this.getInsets();
        this.setSize(this.gridPanel.getPreferredSize().width + insets.left + insets.right + 10, this.gridPanel.getPreferredSize().height + insets.top + insets.bottom + 10);
    }

    protected int forceXInBounds(int x) {
        x = x < 0 ? 0 : x;
        x = x >= this.spaceSize.width ? this.spaceSize.width - 1 : x;
        return x;
    }

    protected int forceYInBounds(int y) {
        y = y < 0 ? 0 : y;
        y = y >= this.spaceSize.height ? this.spaceSize.height - 1 : y;
        return y;
    }

    public void setXScale(double range) {
        this.xScaleFactor = (double)this.spaceSize.width / range;
    }

    public void setYScale(double range) {
        this.yScaleFactor = (double)this.spaceSize.height / range;
    }

    protected int scaleX(double x) {
        int centerX = (int)Math.rint((double)this.spaceSize.width / 2.0);
        int scaled = centerX + (int)Math.rint(x * this.xScaleFactor);
        return this.forceXInBounds(scaled);
    }

    protected int scaleTime(double time, double timeScale) {
        this.setXScale(timeScale);
        return this.scaleX(time);
    }

    protected int scaleY(double y) {
        int centerY = (int)Math.rint((double)this.spaceSize.height / 2.0);
        int scaled = centerY + (int)Math.rint(y * this.yScaleFactor);
        return this.forceYInBounds(scaled);
    }

    public void drawCell(int cellX, int cellY, Color color) {
        int x = this.forceXInBounds(cellX) * this.cellSize + 1;
        int y = this.forceYInBounds(cellY) * this.cellSize + 1;
        this.fillCellOnSwingThread(x, y, color);
    }

    public void drawCellToScale(double cellX, double cellY, Color color) {
        int x = this.scaleX(cellX) * this.cellSize + 1;
        int y = this.scaleY(-cellY) * this.cellSize + 1;
        this.fillCellOnSwingThread(x, y, color);
    }

    public void drawCellToTimeScale(double cellX, double timeScale, double cellY, Color color) {
        int x = this.scaleTime(cellX, timeScale) * this.cellSize + 1;
        int y = this.scaleY(-cellY) * this.cellSize + 1;
        this.fillCellOnSwingThread(x, y, color);
    }

    public void drawPulseToTimeScale(double cellX, double timeScale, double cellY, Color color) {
        int x = this.scaleTime(cellX, timeScale) * this.cellSize + 1;
        int y = this.scaleY(-cellY) * this.cellSize + 1;
        this.fillColumn(x, y, color);
    }

    protected void fillCell(int pixelX, int pixelY, Color color) {
        Graphics g = this.gridPanel.getGraphics();
        g.setColor(color);
        g.fillRect(pixelX, pixelY, this.cellSize - 1, this.cellSize - 1);
        this.grid[pixelX / this.cellSize][pixelY / this.cellSize] = color;
    }

    protected void fillCellOnSwingThread(final int pixelX, final int pixelY, final Color color) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CellGridView.this.fillCell(pixelX, pixelY, color);
            }
        });
    }

    protected void fillColumn(final int pixelX, final int pixelY, final Color color) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Graphics g = CellGridView.this.gridPanel.getGraphics();
                g.setColor(color);
                int gridHeight = CellGridView.this.spaceSize.height * CellGridView.this.cellSize;
                int toZero = gridHeight - pixelY - gridHeight / 2;
                if (toZero >= 0) {
                    int i = 0;
                    while (i <= toZero / CellGridView.this.cellSize) {
                        CellGridView.this.fillCell(pixelX, pixelY + i * CellGridView.this.cellSize, color);
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i <= -toZero / CellGridView.this.cellSize) {
                        CellGridView.this.fillCell(pixelX, pixelY - i * CellGridView.this.cellSize, color);
                        ++i;
                    }
                }
            }
        });
    }

    public void drawString(int cellX, int cellY, final String string, final Color color) {
        final int x = this.forceXInBounds(cellX) * this.cellSize;
        final int y = this.forceYInBounds(-cellY) * this.cellSize;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Graphics g = CellGridView.this.gridPanel.getGraphics();
                g.setColor(color);
                g.drawString(string, x + CellGridView.this.cellSize / 2, y + CellGridView.this.cellSize / 2);
            }
        });
    }

    public Dimension getSpaceSize() {
        return this.spaceSize;
    }

    public void setSpaceSize(Dimension size) {
        this.spaceSize = size;
        this.createGrid();
        this.adjustSizeToHoldGridPanel();
    }

    public int getCellSize() {
        return this.cellSize;
    }

    public void setCellSize(int size) {
        this.cellSize = size;
        this.adjustSizeToHoldGridPanel();
    }

    public String getXLabel() {
        return this.xLabel;
    }

    public void setXLabel(String label) {
        this.xLabel = label;
    }

    protected void createGrid() {
        this.grid = new Color[this.spaceSize.width][this.spaceSize.height];
    }

    public void clearGrid() {
        int i = 0;
        while (i < this.spaceSize.width) {
            int j = 0;
            while (j < this.spaceSize.height) {
                this.grid[i][j] = null;
                ++j;
            }
            ++i;
        }
        this.repaint();
    }

    protected class GridPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public GridPanel() {
            this.setBackground(Color.white);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(CellGridView.this.spaceSize.width * CellGridView.this.cellSize, CellGridView.this.spaceSize.height * CellGridView.this.cellSize);
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            int width = CellGridView.this.spaceSize.width * CellGridView.this.cellSize;
            int halfX = width / 2;
            int height = CellGridView.this.spaceSize.height * CellGridView.this.cellSize;
            int halfY = height / 2;
            g.drawRect(halfX, halfY, CellGridView.this.cellSize, CellGridView.this.cellSize);
            g.drawString("0,0", halfX + 4, halfY - 4);
            g.drawString(CellGridView.this.xLabel, width - CellGridView.this.labelFontMetrics.stringWidth(CellGridView.this.xLabel) - 4, halfY - 4);
            g.drawString(CellGridView.this.yLabel, halfX + 4, CellGridView.this.labelFontAscent + 4);
            g.drawLine(halfX, 0, halfX, height);
            g.drawLine(0, halfY, width, halfY);
            int i = 0;
            while (i < CellGridView.this.spaceSize.width) {
                int j = 0;
                while (j < CellGridView.this.spaceSize.height) {
                    if (CellGridView.this.grid[i][j] != null) {
                        g.setColor(CellGridView.this.grid[i][j]);
                        g.fillRect(i * CellGridView.this.cellSize + 1, j * CellGridView.this.cellSize + 1, CellGridView.this.cellSize - 1, CellGridView.this.cellSize - 1);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }
}

