/*
 * Decompiled with CFR 0.152.
 */
package genDevs.simulation;

import GenCol.EntityInterface;
import GenCol.Function;
import GenCol.Pair;
import GenCol.Relation;
import GenCol.ensembleBag;
import GenCol.ensembleSet;
import GenCol.entity;
import genDevs.modeling.ContentInterface;
import genDevs.modeling.ContentIteratorInterface;
import genDevs.modeling.Coupled;
import genDevs.modeling.IOBasicDevs;
import genDevs.modeling.MessageInterface;
import genDevs.modeling.atomic;
import genDevs.modeling.componentIterator;
import genDevs.modeling.content;
import genDevs.modeling.coupledDevs;
import genDevs.modeling.couprel;
import genDevs.modeling.digraph;
import genDevs.modeling.message;
import genDevs.modeling.port;
import genDevs.simulation.AtomicSimulatorUtil;
import genDevs.simulation.CoordinatorInterface;
import genDevs.simulation.CoupledCoordinatorInterface;
import genDevs.simulation.CoupledSimulatorInterface;
import genDevs.simulation.CouplingProtocolInterface;
import genDevs.simulation.atomicSimulator;
import genDevs.simulation.coupledCoordinator;
import genDevs.simulation.coupledSimulator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import util.Logging;

public class coordinator
extends atomicSimulator
implements CoordinatorInterface {
    private static final long serialVersionUID = 944009650577756776L;
    protected coupledDevs myCoupled;
    protected couprel cr;
    protected Function modelToSim;
    protected Function internalModelTosim;
    protected ensembleSet simulators;
    protected double e;
    protected double INFINITY = Double.POSITIVE_INFINITY;
    protected couprel coupInfo;
    protected couprel extCoupInfo;

    public coordinator() {
    }

    public coordinator(coupledDevs c, boolean core) {
        this.myCoupled = c;
        this.myModel = (IOBasicDevs)((Object)c);
        this.simulators = new ensembleSet();
        this.cr = c.getCouprel();
        this.modelToSim = new Function();
        this.internalModelTosim = new Function();
        this.coupInfo = new couprel();
        this.extCoupInfo = new couprel();
        this.input = new message();
        this.output = new message();
    }

    public coordinator(coupledDevs c) {
        this(c, true, null);
    }

    public coordinator(coupledDevs c, boolean setSimulators, Object dummyParameter) {
        this.myCoupled = c;
        this.myModel = (IOBasicDevs)((Object)c);
        this.cr = c.getCouprel();
        this.modelToSim = new Function();
        this.internalModelTosim = new Function();
        this.coupInfo = new couprel();
        this.extCoupInfo = new couprel();
        this.input = new message();
        this.output = new message();
        this.simulators = new ensembleSet();
        c.setCoordinator(this);
        if (setSimulators) {
            this.setSimulators();
            this.informCoupling();
        }
    }

    @Override
    public coupledDevs getCoupled() {
        return this.myCoupled;
    }

    @Override
    public void setSimulators() {
        componentIterator cit = this.myCoupled.getComponents().cIterator();
        while (cit.hasNext()) {
            IOBasicDevs iod = cit.nextComponent();
            if (iod instanceof atomic) {
                this.addSimulator(iod);
                continue;
            }
            if (iod instanceof digraph) {
                this.addCoordinator((Coupled)iod);
                continue;
            }
            throw new RuntimeException("this model type is not supported by the coordinator");
        }
        this.tellAllSimsSetModToSim();
    }

    protected void tellAllSimsSetModToSim() {
        Class[] classes = new Class[]{ensembleBag.getTheClass("GenCol.Function")};
        Object[] args = new Object[]{this.modelToSim};
        this.simulators.tellAll("setModToSim", classes, args);
    }

    @Override
    public void addSimulator(IOBasicDevs comp) {
        coupledSimulator s = new coupledSimulator(comp);
        s.setRootParent(this);
        this.simulatorCreated(s, comp);
    }

    @Override
    public void addCoordinator(Coupled comp) {
        coupledCoordinator s = new coupledCoordinator(comp);
        s.setRootParent(this);
        this.simulatorCreated(s, comp);
    }

    protected void simulatorCreated(atomicSimulator simulator, IOBasicDevs devs2) {
        this.simulators.add(simulator);
        this.modelToSim.put(devs2.getName(), simulator);
        this.internalModelTosim.put(devs2.getName(), simulator);
    }

    @Override
    public void putMyMessages(ContentInterface c) {
        this.output.add(c);
    }

    @Override
    public void showCoupling() {
        System.out.println("The coupling is: ");
        this.extCoupInfo.print();
    }

    @Override
    public void informCoupling() {
        Iterator it = this.cr.iterator();
        while (it.hasNext()) {
            CouplingProtocolInterface sim;
            Pair pr = (Pair)it.next();
            Pair cs = (Pair)pr.getKey();
            Pair cd = (Pair)pr.getValue();
            String src = (String)cs.getKey();
            if (src.equals(this.myCoupled.getName())) {
                this.addExtPair(cs, cd);
                continue;
            }
            if (this.modelToSim.get(src) instanceof CoupledSimulatorInterface) {
                sim = (CoupledSimulatorInterface)this.modelToSim.get(src);
                sim.addPair(cs, cd);
                continue;
            }
            if (!(this.modelToSim.get(src) instanceof CoupledCoordinatorInterface)) continue;
            sim = (CoupledCoordinatorInterface)this.modelToSim.get(src);
            sim.addPair(cs, cd);
        }
    }

    @Override
    public void addExtPair(Pair cs, Pair cd) {
        this.extCoupInfo.add(cs, cd);
    }

    public double getTNC() {
        return this.tN;
    }

    public double getTLC() {
        return this.tL;
    }

    @Override
    public void initialize() {
        this.simulators.tellAll("initialize");
        this.tL = 0.0;
        this.tN = this.nextTN();
    }

    @Override
    public void initialize(Double d) {
        this.initialize((double)d);
    }

    @Override
    public void initialize(double time) {
        System.out.println(String.valueOf(this.myCoupled.getName()) + " Initialize !!!!!!!!!!!");
        Class[] classes = new Class[]{ensembleBag.getTheClass("java.lang.Double")};
        Object[] args = new Object[]{new Double(time)};
        this.simulators.tellAll("initialize", classes, args);
        this.tN = this.nextTN();
    }

    @Override
    public double nextTN() {
        ensembleSet result = new ensembleSet();
        Class[] classes = new Class[]{};
        Object[] args = new Object[]{};
        this.simulators.AskAll(result, "nextTNDouble", classes, args);
        TreeSet t = new TreeSet(result);
        Double d = (Double)t.first();
        return d;
    }

    @Override
    public void computeInputOutput(double time) {
        Class[] classes = new Class[]{ensembleBag.getTheClass("java.lang.Double")};
        Object[] args = new Object[]{new Double(time)};
        this.simulators.tellAll("computeInputOutput", classes, args);
        this.simulators.tellAll("sendMessages");
    }

    public void wrapDeltFunc(double time) {
        this.wrapDeltfunc(time);
    }

    @Override
    public void wrapDeltfunc(double time) {
        this.sendDownMessages();
        Class[] classes = new Class[]{ensembleBag.getTheClass("java.lang.Double")};
        Object[] args = new Object[]{new Double(time)};
        this.simulators.tellAll("DeltFunc", classes, args);
        this.tL = time;
        this.tN = this.nextTN();
        this.input = new message();
        this.output = new message();
    }

    @Override
    public void sendDownMessages() {
        if (!this.input.isEmpty()) {
            Relation r = this.convertInput(this.input);
            Iterator rit = r.iterator();
            while (rit.hasNext()) {
                CouplingProtocolInterface sim;
                Pair p = (Pair)rit.next();
                Object ds = p.getKey();
                content co = (content)p.getValue();
                if (this.internalModelTosim.get(ds) instanceof CoupledSimulatorInterface) {
                    sim = (CoupledSimulatorInterface)this.internalModelTosim.get(ds);
                    sim.putMessages(co);
                    continue;
                }
                if (!(this.internalModelTosim.get(ds) instanceof CoupledCoordinatorInterface)) continue;
                sim = (CoupledCoordinatorInterface)this.internalModelTosim.get(ds);
                sim.putMessages(co);
            }
        }
    }

    @Override
    public Relation convertInput(MessageInterface x) {
        Relation r = new Relation();
        if (x.isEmpty()) {
            return r;
        }
        ContentIteratorInterface cit = ((message)x).mIterator();
        while (cit.hasNext()) {
            content co = (content)cit.next();
            HashSet s = this.extCoupInfo.translate(this.myCoupled.getName(), co.getPort().getName());
            for (Pair cp : s) {
                Object ds = cp.getKey();
                String por = (String)cp.getValue();
                Object tempval = co.getValue();
                content tempco = new content(por, (entity)tempval);
                r.put(ds, tempco);
                this.convertInputHook1(co, cp, tempco);
            }
        }
        return r;
    }

    @Override
    public void simInject(double e, MessageInterface m) {
        double t = this.tL + e;
        if (t <= this.nextTN()) {
            this.input = m;
            this.wrapDeltfunc(t);
            this.showModelState();
        } else {
            System.out.println("Time: " + this.tL + " ,ERROR input rejected : elapsed time " + e + " is not in bounds.");
        }
    }

    public String toString() {
        return this.myCoupled.toString();
    }

    @Override
    public void showModelState() {
        this.simulators.tellAll("showModelState");
    }

    @Override
    public void simulate(int num_iter) {
        int i = 1;
        this.tN = this.nextTN();
        while (this.tN < Double.POSITIVE_INFINITY && i <= num_iter) {
            Logging.log("ITERATION " + i + " ,time: " + this.tN, 100);
            this.computeInputOutput(this.tN);
            this.showOutput();
            this.wrapDeltfunc(this.tN);
            this.tL = this.tN;
            this.tN = this.nextTN();
            this.showModelState();
            ++i;
        }
        System.out.println("Terminated Normally at ITERATION " + i + " ,time: " + this.tN);
    }

    @Override
    public MessageInterface makeMessage() {
        return new message();
    }

    @Override
    public void simInject(double e, String portName, entity value) {
        this.simInject(e, new port(portName), (EntityInterface)value);
    }

    public List getCouplingsToSourcePort(String portName) {
        return AtomicSimulatorUtil.getCouplingsToSourcePort(portName, this.myCoupled.getName(), this.coupInfo, this.extCoupInfo, this.modelToSim, this.internalModelTosim, null);
    }

    protected void convertInputHook1(content oldContent, Pair coupling, content newContent) {
    }
}

