/*
 * Decompiled with CFR 0.152.
 */
package genDevs.simulation.distributed;

import GenCol.Pair;
import genDevs.modeling.ContentInterface;
import genDevs.modeling.IOBasicDevs;
import genDevs.modeling.content;
import genDevs.modeling.message;
import genDevs.simulation.coupledSimulator;
import genDevs.simulation.distributed.RTCoordinatorServer;
import genDevs.simulation.distributed.Util;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.Socket;
import java.util.Iterator;

public class SimulatorProxy
extends coupledSimulator {
    private static final long serialVersionUID = 5296575290048443393L;
    protected BufferedReader inputStream;
    protected PrintStream printStream;
    protected RTCoordinatorServer server;
    protected boolean quit = false;

    public SimulatorProxy(Socket socket, RTCoordinatorServer server_) {
        this.server = server_;
        try {
            this.inputStream = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            this.printStream = new PrintStream(new DataOutputStream(socket.getOutputStream()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        new ListenForClientMessagesThread().start();
    }

    public void stop() {
        this.quit = true;
    }

    protected void waitForSimulatorName() {
        System.out.println("waiting for name");
        String name = this.readMessageFromClient();
        this.myModel = (IOBasicDevs)this.server.getCoupled().withName(name);
        this.server.registerSimulatorProxy(this, name);
        System.out.println("name is : " + name);
    }

    protected void waitForMessageFromClient() {
        String string = this.readMessageFromClient();
        System.out.println("proxy for " + this.myModel.getName() + " received message from client: " + string);
        message message2 = Util.interpret(string);
        if (!message2.isEmpty()) {
            Iterator i = this.convertMsg(message2).iterator();
            while (i.hasNext()) {
                Pair pair = (Pair)i.next();
                content content2 = (content)pair.getValue();
                SimulatorProxy proxy = (SimulatorProxy)this.modelToSim.get(pair.getKey());
                if (proxy != null) {
                    proxy.putMessages(content2);
                    continue;
                }
                this.server.putMyMessages(content2);
            }
        }
    }

    @Override
    public void putMessages(ContentInterface content2) {
        this.input.add(content2);
        this.sendInputToClient();
        this.input = new message();
    }

    protected void sendInputToClient() {
        if (!this.input.isEmpty()) {
            String string = this.input.toString();
            System.out.println("sendInput:" + string);
            this.sendMessage(string);
        }
    }

    public void sendMessage(String message2) {
        this.printStream.println(message2);
    }

    protected String readMessageFromClient() {
        try {
            return this.inputStream.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    protected class ListenForClientMessagesThread
    extends Thread {
        protected ListenForClientMessagesThread() {
        }

        @Override
        public void run() {
            SimulatorProxy.this.waitForSimulatorName();
            while (!SimulatorProxy.this.quit) {
                SimulatorProxy.this.waitForMessageFromClient();
            }
            System.out.println("SimulatorProxy terminated");
        }
    }
}

